/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.item.MaidGroup;
import com.github.tartaricacid.touhoulittlemaid.util.MaidRayTraceHelper;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class ItemCamera
extends Item {
    private static final String MAID_INFO = "MaidInfo";

    public ItemCamera() {
        super(new Item.Properties().func_200916_a(MaidGroup.MAIN_TAB).func_200917_a(1).func_200918_c(50));
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        if (handIn == Hand.MAIN_HAND) {
            int searchDistance = 8;
            ItemStack camera = playerIn.func_184586_b(handIn);
            Optional<EntityMaid> result = MaidRayTraceHelper.rayTraceMaid(playerIn, searchDistance);
            if (result.isPresent()) {
                EntityMaid maid = result.get();
                if (!worldIn.field_72995_K && maid.func_70089_S() && maid.func_152114_e((LivingEntity)playerIn) && !maid.func_70608_bn()) {
                    this.spawnMaidPhoto(worldIn, maid, playerIn);
                    maid.func_70106_y();
                    playerIn.func_184811_cZ().func_185145_a((Item)this, 20);
                    camera.func_222118_a(1, (LivingEntity)playerIn, e -> e.func_213334_d(Hand.MAIN_HAND));
                }
                maid.spawnExplosionParticle();
                playerIn.func_184185_a((SoundEvent)InitSounds.CAMERA_USE.get(), 1.0f, 1.0f);
                return ActionResult.func_233538_a_((Object)camera, (boolean)worldIn.field_72995_K);
            }
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    private void spawnMaidPhoto(World worldIn, EntityMaid maid, PlayerEntity playerIn) {
        ItemStack photo = ((Item)InitItems.PHOTO.get()).func_190903_i();
        CompoundNBT photoTag = new CompoundNBT();
        CompoundNBT maidTag = new CompoundNBT();
        maid.setHomeModeEnable(false);
        maid.func_189511_e(maidTag);
        maidTag.func_74778_a("id", Objects.requireNonNull(((EntityType)InitEntities.MAID.get()).getRegistryName()).toString());
        photoTag.func_218657_a(MAID_INFO, (INBT)maidTag);
        photo.func_77982_d(photoTag);
        InventoryHelper.func_180173_a((World)worldIn, (double)playerIn.func_226277_ct_(), (double)playerIn.func_226278_cu_(), (double)playerIn.func_226281_cx_(), (ItemStack)photo);
    }

    public ActionResultType func_111207_a(ItemStack stack, PlayerEntity playerIn, LivingEntity target, Hand hand) {
        if (stack.func_77973_b() == this && target.func_70089_S() && target instanceof EntityMaid && ((EntityMaid)target).func_152114_e((LivingEntity)playerIn)) {
            this.func_77659_a(playerIn.field_70170_p, playerIn, hand);
            return ActionResultType.SUCCESS;
        }
        return super.func_111207_a(stack, playerIn, target, hand);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltips.touhou_little_maid.camera.desc").func_240699_a_(TextFormatting.DARK_GREEN));
    }
}

