/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.client.renderer.tileentity.TileEntityItemStackChairRenderer;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityChair;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.item.MaidGroup;
import com.github.tartaricacid.touhoulittlemaid.util.ParseI18n;
import com.google.common.base.Predicates;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class ItemChair
extends Item {
    private static final String DEFAULT_MODEL_ID = "touhou_little_maid:cushion";

    public ItemChair() {
        super(new Item.Properties().func_200916_a(MaidGroup.CHAIR_TAB).func_200917_a(1).setISTER(() -> TileEntityItemStackChairRenderer::new));
    }

    public static Data getData(ItemStack stack) {
        if (stack.func_77973_b() == InitItems.CHAIR.get()) {
            return Data.deserialization(stack.func_196082_o());
        }
        return new Data(DEFAULT_MODEL_ID, 0.0f, true, false);
    }

    public static ItemStack setData(ItemStack stack, Data data) {
        if (stack.func_77973_b() == InitItems.CHAIR.get()) {
            Data.serialization(stack.func_196082_o(), data);
        }
        return stack;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        if (context.func_196000_l() != Direction.DOWN) {
            World world = context.func_195991_k();
            BlockPos clickedPos = new BlockItemUseContext(context).func_195995_a();
            AxisAlignedBB boundingBox = EntityChair.TYPE.func_220334_j().func_242286_a(Vector3d.func_237492_c_((Vector3i)clickedPos));
            if (world.func_234865_b_(null, boundingBox, (Predicate)Predicates.alwaysTrue()) && world.func_72839_b(null, boundingBox).isEmpty()) {
                ItemStack stack = context.func_195996_i();
                if (world instanceof ServerWorld) {
                    EntityChair chair;
                    ServerWorld serverWorld = (ServerWorld)world;
                    ITextComponent customName = null;
                    if (stack.func_82837_s()) {
                        customName = stack.func_151000_E();
                    }
                    if ((chair = (EntityChair)EntityChair.TYPE.func_220349_b(serverWorld, stack.func_77978_p(), customName, context.func_195999_j(), clickedPos, SpawnReason.SPAWN_EGG, true, true)) == null) {
                        return ActionResultType.FAIL;
                    }
                    this.addExtraData(context, stack, chair);
                    world.func_217376_c((Entity)chair);
                    world.func_184148_a(null, chair.func_226277_ct_(), chair.func_226278_cu_(), chair.func_226281_cx_(), SoundEvents.field_187552_ah, SoundCategory.BLOCKS, 0.75f, 0.8f);
                }
                stack.func_190918_g(1);
                return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
            }
        }
        return ActionResultType.FAIL;
    }

    private void addExtraData(ItemUseContext context, ItemStack stack, EntityChair chair) {
        Data data = Data.deserialization(stack.func_196082_o());
        chair.setModelId(data.getModelId());
        chair.setMountedHeight(data.getHeight());
        chair.setTameableCanRide(data.isCanRide());
        chair.func_189654_d(data.isNoGravity());
        chair.setOwner(context.func_195999_j());
        float yaw = (float)MathHelper.func_76141_d((float)((MathHelper.func_76142_g((float)(context.func_195990_h() - 180.0f)) + 22.5f) / 45.0f)) * 45.0f;
        chair.func_70012_b(chair.func_226277_ct_(), chair.func_226278_cu_(), chair.func_226281_cx_(), yaw, 0.0f);
        chair.func_181013_g(yaw);
        chair.func_70034_d(yaw);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            for (String key : CustomPackLoader.CHAIR_MODELS.getModelIdSet()) {
                float height = CustomPackLoader.CHAIR_MODELS.getModelMountedYOffset(key);
                boolean canRide = CustomPackLoader.CHAIR_MODELS.getModelTameableCanRide(key);
                boolean isNoGravity = CustomPackLoader.CHAIR_MODELS.getModelNoGravity(key);
                items.add((Object)ItemChair.setData(this.func_190903_i(), new Data(key, height, canRide, isNoGravity)));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public ITextComponent func_200295_i(ItemStack stack) {
        Data data;
        if (FMLEnvironment.dist == Dist.CLIENT && CustomPackLoader.CHAIR_MODELS.getInfo((data = ItemChair.getData(stack)).getModelId()).isPresent()) {
            String name = CustomPackLoader.CHAIR_MODELS.getInfo(data.getModelId()).get().getName();
            return ParseI18n.parse(name);
        }
        return super.func_200295_i(stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltips.touhou_little_maid.chair.place.desc").func_240699_a_(TextFormatting.GRAY));
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltips.touhou_little_maid.chair.destroy.desc").func_240699_a_(TextFormatting.GRAY));
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltips.touhou_little_maid.chair.gui.desc").func_240699_a_(TextFormatting.GRAY));
        if (flagIn.func_194127_a() && Screen.func_231173_s_()) {
            Data data = Data.deserialization(stack.func_196082_o());
            tooltip.add((ITextComponent)new StringTextComponent("Model Id: " + data.getModelId()).func_240699_a_(TextFormatting.GRAY));
            tooltip.add((ITextComponent)new StringTextComponent("Mounted Height: " + data.getHeight()).func_240699_a_(TextFormatting.GRAY));
            tooltip.add((ITextComponent)new StringTextComponent("Tameable Can Ride: " + data.isCanRide()).func_240699_a_(TextFormatting.GRAY));
            tooltip.add((ITextComponent)new StringTextComponent("Is No Gravity: " + data.isNoGravity()).func_240699_a_(TextFormatting.GRAY));
        }
    }

    public static class Data {
        private static final String MODEL_ID_TAG = "ModelId";
        private static final String MOUNTED_HEIGHT_TAG = "MountedHeight";
        private static final String TAMEABLE_CAN_RIDE_TAG = "TameableCanRide";
        private static final String IS_NO_GRAVITY_TAG = "IsNoGravity";
        private final String modelId;
        private final float height;
        private final boolean canRide;
        private final boolean isNoGravity;

        public Data(String modelId, float height, boolean canRide, boolean isNoGravity) {
            this.modelId = modelId;
            this.height = height;
            this.canRide = canRide;
            this.isNoGravity = isNoGravity;
        }

        public static void serialization(@Nonnull CompoundNBT nbt, Data data) {
            nbt.func_74778_a(MODEL_ID_TAG, data.getModelId());
            nbt.func_74776_a(MOUNTED_HEIGHT_TAG, data.getHeight());
            nbt.func_74757_a(TAMEABLE_CAN_RIDE_TAG, data.isCanRide());
            nbt.func_74757_a(IS_NO_GRAVITY_TAG, data.isNoGravity());
        }

        public static Data deserialization(@Nonnull CompoundNBT nbt) {
            String modelId = ItemChair.DEFAULT_MODEL_ID;
            float height = 0.0f;
            boolean canRide = true;
            boolean isNoGravity = false;
            if (nbt.func_150297_b(MODEL_ID_TAG, 8)) {
                modelId = nbt.func_74779_i(MODEL_ID_TAG);
            }
            if (nbt.func_150297_b(MOUNTED_HEIGHT_TAG, 5)) {
                height = nbt.func_74760_g(MOUNTED_HEIGHT_TAG);
            }
            if (nbt.func_150297_b(TAMEABLE_CAN_RIDE_TAG, 1)) {
                canRide = nbt.func_74767_n(TAMEABLE_CAN_RIDE_TAG);
            }
            if (nbt.func_150297_b(IS_NO_GRAVITY_TAG, 1)) {
                isNoGravity = nbt.func_74767_n(IS_NO_GRAVITY_TAG);
            }
            return new Data(modelId, height, canRide, isNoGravity);
        }

        public String getModelId() {
            return this.modelId;
        }

        public float getHeight() {
            return this.height;
        }

        public boolean isCanRide() {
            return this.canRide;
        }

        public boolean isNoGravity() {
            return this.isNoGravity;
        }
    }
}

