/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.block.BlockStatue;
import com.github.tartaricacid.touhoulittlemaid.init.InitBlocks;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.item.ItemPhoto;
import com.github.tartaricacid.touhoulittlemaid.item.MaidGroup;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityStatue;
import com.google.common.collect.Lists;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class ItemChisel
extends Item {
    public ItemChisel() {
        super(new Item.Properties().func_200916_a(MaidGroup.MAIN_TAB).func_200917_a(1).func_200918_c(64));
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World worldIn = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        PlayerEntity player = context.func_195999_j();
        if (context.func_221531_n() == Hand.MAIN_HAND && player != null) {
            if (worldIn.func_180495_p(pos).func_177230_c() != Blocks.field_150435_aG) {
                if (!worldIn.field_72995_K) {
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("message.touhou_little_maid.chisel.hit_block_error"), Util.field_240973_b_);
                }
                return ActionResultType.PASS;
            }
            if (player.func_184592_cb().func_77973_b() != InitItems.PHOTO.get()) {
                if (!worldIn.field_72995_K) {
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("message.touhou_little_maid.chisel.offhand_not_photo"), Util.field_240973_b_);
                }
                return ActionResultType.PASS;
            }
            this.genStatueBlocks(player, worldIn, pos, context.func_196000_l());
            return ActionResultType.SUCCESS;
        }
        return super.func_195939_a(context);
    }

    private void genStatueBlocks(@Nonnull PlayerEntity player, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull Direction facing) {
        CompoundNBT data = ItemPhoto.getMaidData(player.func_184592_cb());
        TileEntityStatue.Size[] sizes = TileEntityStatue.Size.values();
        for (int i = sizes.length - 1; i >= 0; --i) {
            TileEntityStatue.Size size = sizes[i];
            Vector3i dimension = size.getDimension();
            Object[] posList = this.checkBlocks(worldIn, pos, dimension, facing);
            if (posList == null) continue;
            boolean isTiny = false;
            if (posList.length == 1) {
                isTiny = true;
            }
            for (BlockPos blockPos : posList) {
                worldIn.func_180501_a(blockPos, (BlockState)((Block)InitBlocks.STATUE.get()).func_176223_P().func_206870_a((Property)BlockStatue.IS_TINY, (Comparable)Boolean.valueOf(isTiny)), 3);
                TileEntity te = worldIn.func_175625_s(blockPos);
                if (!(te instanceof TileEntityStatue)) continue;
                TileEntityStatue statue = (TileEntityStatue)te;
                if (blockPos.equals((Object)pos)) {
                    statue.setForgeData(size, true, pos, facing, Lists.newArrayList((Object[])posList), data);
                    continue;
                }
                statue.setForgeData(size, false, pos, facing, Lists.newArrayList((Object[])posList), null);
            }
            player.func_184614_ca().func_222118_a(size.ordinal() + 1, (LivingEntity)player, e -> e.func_213334_d(Hand.MAIN_HAND));
            player.func_184185_a(SoundEvents.field_187689_f, 0.5f, 1.5f);
            return;
        }
    }

    @Nullable
    private BlockPos[] checkBlocks(@Nonnull World worldIn, BlockPos origin, Vector3i dimension, Direction facing) {
        BlockPos[] posList = new BlockPos[dimension.func_177958_n() * dimension.func_177956_o() * dimension.func_177952_p()];
        int index = 0;
        for (int x = 0; x < dimension.func_177958_n(); ++x) {
            for (int y = 0; y < dimension.func_177956_o(); ++y) {
                for (int z = 0; z < dimension.func_177952_p(); ++z) {
                    BlockPos pos;
                    switch (facing) {
                        case WEST: {
                            pos = origin.func_177971_a(new Vector3i(x, y, z));
                            break;
                        }
                        case SOUTH: {
                            pos = origin.func_177971_a(new Vector3i(x, y, -z));
                            break;
                        }
                        default: {
                            pos = origin.func_177971_a(new Vector3i(-x, y, z));
                            break;
                        }
                        case EAST: {
                            pos = origin.func_177971_a(new Vector3i(-x, y, -z));
                        }
                    }
                    posList[index] = pos;
                    ++index;
                    if (worldIn.func_180495_p(pos).func_177230_c() == Blocks.field_150435_aG) continue;
                    return null;
                }
            }
        }
        return posList;
    }
}

