/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.client.renderer.tileentity.TileEntityEntityPlaceholderRenderer;
import com.github.tartaricacid.touhoulittlemaid.crafting.AltarRecipe;
import com.github.tartaricacid.touhoulittlemaid.init.InitRecipes;
import com.github.tartaricacid.touhoulittlemaid.item.MaidGroup;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemEntityPlaceholder
extends Item {
    private static final String RECIPES_ID_TAG = "RecipeId";

    public ItemEntityPlaceholder() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(MaidGroup.MAIN_TAB).setISTER(() -> TileEntityEntityPlaceholderRenderer::new));
    }

    public static ItemStack setRecipeId(ItemStack stack, ResourceLocation id) {
        stack.func_196082_o().func_74778_a(RECIPES_ID_TAG, id.toString());
        return stack;
    }

    @Nullable
    public static ResourceLocation getRecipeId(ItemStack stack) {
        CompoundNBT tag;
        if (stack.func_77942_o() && (tag = stack.func_77978_p()).func_150297_b(RECIPES_ID_TAG, 8)) {
            return new ResourceLocation(tag.func_74779_i(RECIPES_ID_TAG));
        }
        return null;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        if (context.func_196000_l() == Direction.UP) {
            IRecipe recipe;
            ResourceLocation id = ItemEntityPlaceholder.getRecipeId(context.func_195996_i());
            World world = context.func_195991_k();
            if (id != null && world instanceof ServerWorld && (recipe = (IRecipe)context.func_195991_k().func_199532_z().func_215366_a(InitRecipes.ALTAR_CRAFTING).get(id)) instanceof AltarRecipe) {
                AltarRecipe altarRecipe = (AltarRecipe)recipe;
                altarRecipe.spawnOutputEntity((ServerWorld)world, context.func_195995_a().func_177984_a(), null);
                context.func_195996_i().func_190918_g(1);
            }
        }
        return super.func_195939_a(context);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            ClientWorld world = Minecraft.func_71410_x().field_71441_e;
            if (world == null) {
                return;
            }
            world.func_199532_z().func_241447_a_(InitRecipes.ALTAR_CRAFTING).forEach(recipe -> {
                if (!recipe.isItemCraft()) {
                    items.add((Object)ItemEntityPlaceholder.setRecipeId(this.func_190903_i(), recipe.func_199560_c()));
                }
            });
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public ITextComponent func_200295_i(ItemStack stack) {
        ResourceLocation recipeId = ItemEntityPlaceholder.getRecipeId(stack);
        if (recipeId != null) {
            Path path = Paths.get(recipeId.func_110623_a().toLowerCase(Locale.US), new String[0]);
            String namespace = recipeId.func_110624_b().toLowerCase(Locale.US);
            String langKey = String.format("jei.%s.altar_craft.%s.result", namespace, path.getFileName());
            return new TranslationTextComponent(langKey);
        }
        return new TranslationTextComponent("item.touhou_little_maid.entity_placeholder");
    }
}

