/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.item.MaidGroup;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.SpawnParticleMessage;
import com.github.tartaricacid.touhoulittlemaid.util.ParseI18n;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.apache.commons.lang3.StringUtils;

public class ItemFilm
extends Item {
    public static final String MAID_INFO = "MaidInfo";

    public ItemFilm() {
        super(new Item.Properties().func_200916_a(MaidGroup.MAIN_TAB).func_200917_a(1));
    }

    public static ItemStack maidToFilm(EntityMaid maid) {
        ItemStack film = ((Item)InitItems.FILM.get()).func_190903_i();
        CompoundNBT filmTag = new CompoundNBT();
        CompoundNBT maidTag = new CompoundNBT();
        maid.setHomeModeEnable(false);
        maid.func_189511_e(maidTag);
        ItemFilm.removeMaidSomeData(maidTag);
        maidTag.func_74778_a("id", Objects.requireNonNull(((EntityType)InitEntities.MAID.get()).getRegistryName()).toString());
        filmTag.func_218657_a(MAID_INFO, (INBT)maidTag);
        film.func_77982_d(filmTag);
        return film;
    }

    public static void filmToMaid(ItemStack film, World worldIn, BlockPos pos, PlayerEntity player) {
        Optional entityOptional = EntityType.func_220330_a((CompoundNBT)ItemFilm.getMaidData(film), (World)worldIn);
        if (entityOptional.isPresent() && entityOptional.get() instanceof EntityMaid) {
            EntityMaid maid = (EntityMaid)((Object)entityOptional.get());
            maid.func_70107_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            if (!worldIn.field_72995_K) {
                worldIn.func_217376_c((Entity)maid);
                NetworkHandler.sendToNearby((Entity)maid, new SpawnParticleMessage(maid.func_145782_y(), SpawnParticleMessage.Type.EXPLOSION));
                worldIn.func_184133_a(null, pos, (SoundEvent)InitSounds.ALTAR_CRAFT.get(), SoundCategory.VOICE, 1.0f, 1.0f);
            }
            film.func_190918_g(1);
        }
        if (!worldIn.field_72995_K) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("tooltips.touhou_little_maid.film.no_data.desc"), Util.field_240973_b_);
        }
    }

    private static boolean hasMaidData(ItemStack stack) {
        return stack.func_77942_o() && !Objects.requireNonNull(stack.func_77978_p()).func_74775_l(MAID_INFO).isEmpty();
    }

    private static CompoundNBT getMaidData(ItemStack stack) {
        if (ItemFilm.hasMaidData(stack)) {
            return Objects.requireNonNull(stack.func_77978_p()).func_74775_l(MAID_INFO);
        }
        return new CompoundNBT();
    }

    private static void removeMaidSomeData(CompoundNBT nbt) {
        nbt.func_82580_o("MaidBackpackType");
        nbt.func_82580_o("MaidInventory");
        nbt.func_82580_o("MaidBaubleInventory");
        nbt.func_82580_o("MaidExperience");
        nbt.func_82580_o("ArmorItems");
        nbt.func_82580_o("HandItems");
        nbt.func_82580_o("Leash");
        nbt.func_82580_o("Health");
        nbt.func_82580_o("HurtTime");
        nbt.func_82580_o("DeathTime");
        nbt.func_82580_o("HurtByTimestamp");
        nbt.func_82580_o("Pos");
        nbt.func_82580_o("Motion");
        nbt.func_82580_o("FallDistance");
        nbt.func_82580_o("Fire");
        nbt.func_82580_o("Air");
        nbt.func_82580_o("TicksFrozen");
        nbt.func_82580_o("HasVisualFire");
        nbt.func_82580_o("Passengers");
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        if (!entity.func_190530_aW()) {
            entity.func_184224_h(true);
        }
        Vector3d position = entity.func_213303_ch();
        if (position.field_72448_b < 0.0) {
            entity.func_189654_d(true);
            entity.func_213317_d(Vector3d.field_186680_a);
            entity.func_70107_b(position.field_72450_a, 0.0, position.field_72449_c);
        }
        return super.onEntityItemUpdate(stack, entity);
    }

    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (!ItemFilm.hasMaidData(stack)) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltips.touhou_little_maid.film.no_data.desc").func_240699_a_(TextFormatting.DARK_RED));
        } else {
            String modelId;
            CompoundNBT maidData = ItemFilm.getMaidData(stack);
            if (maidData.func_150297_b("ModelId", 8) && StringUtils.isNotBlank((CharSequence)(modelId = maidData.func_74779_i("ModelId")))) {
                CustomPackLoader.MAID_MODELS.getInfo(modelId).ifPresent(modelItem -> tooltip.add((ITextComponent)new TranslationTextComponent("tooltips.touhou_little_maid.photo.maid.desc", new Object[]{I18n.func_135052_a((String)ParseI18n.getI18nKey(modelItem.getName()), (Object[])new Object[0])}).func_240699_a_(TextFormatting.GRAY)));
            }
        }
    }
}

