/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.item.MaidGroup;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.FoxScrollMessage;
import com.github.tartaricacid.touhoulittlemaid.world.data.MaidInfo;
import com.github.tartaricacid.touhoulittlemaid.world.data.MaidWorldData;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class ItemFoxScroll
extends Item {
    private static final String TRACK_INFO = "TrackInfo";

    public ItemFoxScroll() {
        super(new Item.Properties().func_200916_a(MaidGroup.MAIN_TAB).func_200917_a(1));
    }

    public static boolean hasTrackInfo(ItemStack scroll) {
        return scroll.func_77942_o() && !Objects.requireNonNull(scroll.func_77978_p()).func_74775_l(TRACK_INFO).isEmpty();
    }

    public static void setTrackInfo(ItemStack scroll, String dimension, BlockPos pos) {
        CompoundNBT tag = scroll.func_190925_c(TRACK_INFO);
        tag.func_74778_a("Dimension", dimension);
        tag.func_218657_a("Position", (INBT)NBTUtil.func_186859_a((BlockPos)pos));
    }

    @Nullable
    public static Pair<String, BlockPos> getTrackInfo(ItemStack scroll) {
        if (ItemFoxScroll.hasTrackInfo(scroll)) {
            CompoundNBT tag = Objects.requireNonNull(scroll.func_77978_p()).func_74775_l(TRACK_INFO);
            String dimension = tag.func_74779_i("Dimension");
            BlockPos position = NBTUtil.func_186861_c((CompoundNBT)tag.func_74775_l("Position"));
            return Pair.of((Object)dimension, (Object)position);
        }
        return null;
    }

    public ActionResult<ItemStack> func_77659_a(World level, PlayerEntity player, Hand hand) {
        if (!level.field_72995_K && hand == Hand.MAIN_HAND) {
            ItemStack item = player.func_184614_ca();
            MaidWorldData maidWorldData = MaidWorldData.get(level);
            if (maidWorldData == null) {
                return super.func_77659_a(level, player, hand);
            }
            HashMap data = Maps.newHashMap();
            List<MaidInfo> maidInfos = null;
            if (item.func_77973_b() == InitItems.RED_FOX_SCROLL.get()) {
                maidInfos = maidWorldData.getPlayerMaidInfos(player);
            } else if (item.func_77973_b() == InitItems.WHITE_FOX_SCROLL.get()) {
                maidInfos = maidWorldData.getPlayerMaidTombstones(player);
            }
            if (maidInfos == null) {
                maidInfos = Collections.emptyList();
            }
            maidInfos.forEach(info -> {
                List scrollData = data.computeIfAbsent(info.getDimension(), dim -> Lists.newArrayList());
                scrollData.add(new FoxScrollMessage.FoxScrollData(info.getChunkPos(), info.getName(), info.getTimestamp()));
            });
            NetworkHandler.sendToClientPlayer(new FoxScrollMessage(data), player);
            return ActionResult.func_226248_a_((Object)item);
        }
        return super.func_77659_a(level, player, hand);
    }

    public void func_77624_a(ItemStack stack, @Nullable World pLevel, List<ITextComponent> components, ITooltipFlag pIsAdvanced) {
        Pair<String, BlockPos> info = ItemFoxScroll.getTrackInfo(stack);
        if (info != null) {
            components.add((ITextComponent)new TranslationTextComponent("tooltips.touhou_little_maid.fox_scroll.dimension", new Object[]{info.getLeft()}).func_240699_a_(TextFormatting.GRAY));
            components.add((ITextComponent)new TranslationTextComponent("tooltips.touhou_little_maid.fox_scroll.position", new Object[]{((BlockPos)info.getRight()).func_229422_x_()}).func_240699_a_(TextFormatting.GRAY));
        }
        if (stack.func_77973_b() == InitItems.RED_FOX_SCROLL.get()) {
            components.add((ITextComponent)new TranslationTextComponent("tooltips.touhou_little_maid.fox_scroll.red").func_240699_a_(TextFormatting.GRAY));
        } else if (stack.func_77973_b() == InitItems.WHITE_FOX_SCROLL.get()) {
            components.add((ITextComponent)new TranslationTextComponent("tooltips.touhou_little_maid.fox_scroll.white").func_240699_a_(TextFormatting.GRAY));
        }
        super.func_77624_a(stack, pLevel, components, pIsAdvanced);
    }
}

