/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.item.MaidGroup;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.schedule.Activity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class ItemKappaCompass
extends Item {
    public ItemKappaCompass() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(MaidGroup.MAIN_TAB));
    }

    public static void addPoint(Activity activity, BlockPos pos, ItemStack compass) {
        CompoundNBT tag = compass.func_190925_c("KappaCompassData");
        tag.func_218657_a(activity.func_221364_a(), (INBT)NBTUtil.func_186859_a((BlockPos)pos));
    }

    public static void addDimension(ResourceLocation dimension, ItemStack compass) {
        CompoundNBT tag = compass.func_190925_c("KappaCompassData");
        tag.func_74778_a("Dimension", dimension.toString());
    }

    @Nullable
    public static BlockPos getPoint(Activity activity, ItemStack compass) {
        CompoundNBT tag = compass.func_179543_a("KappaCompassData");
        if (tag != null) {
            String name = activity.func_221364_a();
            if (tag.func_150297_b(name, 10)) {
                return NBTUtil.func_186861_c((CompoundNBT)tag.func_74775_l(name));
            }
            name = Activity.field_221366_b.func_221364_a();
            if (tag.func_150297_b(name, 10)) {
                return NBTUtil.func_186861_c((CompoundNBT)tag.func_74775_l(name));
            }
            name = Activity.field_221367_c.func_221364_a();
            if (tag.func_150297_b(name, 10)) {
                return NBTUtil.func_186861_c((CompoundNBT)tag.func_74775_l(name));
            }
        }
        return null;
    }

    @Nullable
    public static ResourceLocation getDimension(ItemStack compass) {
        CompoundNBT tag = compass.func_179543_a("KappaCompassData");
        if (tag != null) {
            return new ResourceLocation(tag.func_74779_i("Dimension"));
        }
        return null;
    }

    public static int getRecordCount(ItemStack compass) {
        CompoundNBT tag = compass.func_179543_a("KappaCompassData");
        int count = 0;
        if (tag != null) {
            if (tag.func_150297_b(Activity.field_221367_c.func_221364_a(), 10)) {
                ++count;
            }
            if (tag.func_150297_b(Activity.field_221366_b.func_221364_a(), 10)) {
                ++count;
            }
            if (tag.func_150297_b(Activity.field_221369_e.func_221364_a(), 10)) {
                ++count;
            }
        }
        return count;
    }

    public static boolean hasKappaCompassData(ItemStack compass) {
        return compass.func_179543_a("KappaCompassData") != null;
    }

    public ActionResultType func_111207_a(ItemStack compass, PlayerEntity player, LivingEntity livingEntity, Hand hand) {
        if (livingEntity instanceof EntityMaid && !livingEntity.field_70170_p.field_72995_K) {
            EntityMaid maid = (EntityMaid)livingEntity;
            if (player.func_226273_bm_()) {
                maid.getSchedulePos().clear(maid);
                player.func_145747_a((ITextComponent)new TranslationTextComponent("message.touhou_little_maid.kappa_compass.maid_clear"), Util.field_240973_b_);
                player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), (SoundEvent)InitSounds.COMPASS_POINT.get(), SoundCategory.PLAYERS, 0.8f, 1.5f);
                return ActionResultType.SUCCESS;
            }
            CompoundNBT tag = compass.func_179543_a("KappaCompassData");
            ResourceLocation dimension = ItemKappaCompass.getDimension(compass);
            if (tag != null || dimension != null) {
                if (!maid.field_70170_p.func_234923_W_().func_240901_a_().equals((Object)dimension)) {
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("message.touhou_little_maid.kappa_compass.maid_dimension_check"), Util.field_240973_b_);
                    return ActionResultType.CONSUME;
                }
                maid.getSchedulePos().setDimension(dimension);
                BlockPos point = ItemKappaCompass.getPoint(Activity.field_221367_c, compass);
                if (point != null) {
                    maid.getSchedulePos().setWorkPos(point);
                }
                if ((point = ItemKappaCompass.getPoint(Activity.field_221366_b, compass)) != null) {
                    maid.getSchedulePos().setIdlePos(point);
                }
                if ((point = ItemKappaCompass.getPoint(Activity.field_221369_e, compass)) != null) {
                    maid.getSchedulePos().setSleepPos(point);
                }
                maid.getSchedulePos().setConfigured(true);
                maid.getSchedulePos().restrictTo(maid);
                player.func_145747_a((ITextComponent)new TranslationTextComponent("message.touhou_little_maid.kappa_compass.maid_write"), Util.field_240973_b_);
                player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), (SoundEvent)InitSounds.COMPASS_POINT.get(), SoundCategory.PLAYERS, 0.8f, 1.5f);
                return ActionResultType.SUCCESS;
            }
            player.func_145747_a((ITextComponent)new TranslationTextComponent("message.touhou_little_maid.kappa_compass.no_data"), Util.field_240973_b_);
            return ActionResultType.CONSUME;
        }
        return super.func_111207_a(compass, player, livingEntity, hand);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        ItemStack compass = context.func_195996_i();
        BlockPos clickedPos = context.func_195995_a();
        if (player == null || context.func_195991_k().field_72995_K) {
            return super.func_195939_a(context);
        }
        if (player.func_226273_bm_()) {
            compass.func_196083_e("KappaCompassData");
            player.func_145747_a((ITextComponent)new TranslationTextComponent("message.touhou_little_maid.kappa_compass.clear"), Util.field_240973_b_);
        } else {
            int recordCount = ItemKappaCompass.getRecordCount(compass);
            if (recordCount >= 3) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("message.touhou_little_maid.kappa_compass.full"), Util.field_240973_b_);
            } else if (recordCount == 2) {
                BlockPos idlePos = ItemKappaCompass.getPoint(Activity.field_221366_b, compass);
                if (idlePos != null && idlePos.func_177951_i((Vector3i)clickedPos) > 4096.0) {
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("message.touhou_little_maid.kappa_compass.far_away"), Util.field_240973_b_);
                    return super.func_195939_a(context);
                }
                ItemKappaCompass.addPoint(Activity.field_221369_e, clickedPos, compass);
                player.func_145747_a((ITextComponent)new TranslationTextComponent("message.touhou_little_maid.kappa_compass.sleep", new Object[]{clickedPos.func_177958_n(), clickedPos.func_177956_o(), clickedPos.func_177952_p()}), Util.field_240973_b_);
            } else if (recordCount == 1) {
                BlockPos workPos = ItemKappaCompass.getPoint(Activity.field_221367_c, compass);
                if (workPos != null && workPos.func_177951_i((Vector3i)clickedPos) > 4096.0) {
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("message.touhou_little_maid.kappa_compass.far_away"), Util.field_240973_b_);
                    return super.func_195939_a(context);
                }
                ItemKappaCompass.addPoint(Activity.field_221366_b, clickedPos, compass);
                player.func_145747_a((ITextComponent)new TranslationTextComponent("message.touhou_little_maid.kappa_compass.idle", new Object[]{clickedPos.func_177958_n(), clickedPos.func_177956_o(), clickedPos.func_177952_p()}), Util.field_240973_b_);
            } else {
                ItemKappaCompass.addPoint(Activity.field_221367_c, clickedPos, compass);
                player.func_145747_a((ITextComponent)new TranslationTextComponent("message.touhou_little_maid.kappa_compass.work", new Object[]{clickedPos.func_177958_n(), clickedPos.func_177956_o(), clickedPos.func_177952_p()}), Util.field_240973_b_);
            }
            ItemKappaCompass.addDimension(player.field_70170_p.func_234923_W_().func_240901_a_(), compass);
        }
        player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), (SoundEvent)InitSounds.COMPASS_POINT.get(), SoundCategory.PLAYERS, 0.8f, 1.5f);
        return ActionResultType.SUCCESS;
    }

    public void func_77624_a(ItemStack stack, @Nullable World pLevel, List<ITextComponent> components, ITooltipFlag pIsAdvanced) {
        if (ItemKappaCompass.hasKappaCompassData(stack)) {
            ResourceLocation dimension = ItemKappaCompass.getDimension(stack);
            BlockPos workPos = ItemKappaCompass.getPoint(Activity.field_221367_c, stack);
            BlockPos idlePos = ItemKappaCompass.getPoint(Activity.field_221366_b, stack);
            BlockPos sleepPos = ItemKappaCompass.getPoint(Activity.field_221369_e, stack);
            if (dimension != null) {
                components.add((ITextComponent)new TranslationTextComponent("tooltips.touhou_little_maid.fox_scroll.dimension", new Object[]{dimension.toString()}).func_240699_a_(TextFormatting.GOLD));
            }
            if (workPos != null) {
                components.add((ITextComponent)new TranslationTextComponent("message.touhou_little_maid.kappa_compass.work", new Object[]{workPos.func_177958_n(), workPos.func_177956_o(), workPos.func_177952_p()}).func_240699_a_(TextFormatting.RED));
            }
            if (idlePos != null) {
                components.add((ITextComponent)new TranslationTextComponent("message.touhou_little_maid.kappa_compass.idle", new Object[]{idlePos.func_177958_n(), idlePos.func_177956_o(), idlePos.func_177952_p()}).func_240699_a_(TextFormatting.GREEN));
            }
            if (sleepPos != null) {
                components.add((ITextComponent)new TranslationTextComponent("message.touhou_little_maid.kappa_compass.sleep", new Object[]{sleepPos.func_177958_n(), sleepPos.func_177956_o(), sleepPos.func_177952_p()}).func_240699_a_(TextFormatting.BLUE));
            }
            components.add(StringTextComponent.field_240750_d_);
        }
        components.add((ITextComponent)new TranslationTextComponent("message.touhou_little_maid.kappa_compass.usage.set_pos"));
        components.add((ITextComponent)new TranslationTextComponent("message.touhou_little_maid.kappa_compass.usage.clear_pos"));
        components.add((ITextComponent)new TranslationTextComponent("message.touhou_little_maid.kappa_compass.usage.write_pos_to_maid"));
        components.add((ITextComponent)new TranslationTextComponent("message.touhou_little_maid.kappa_compass.usage.clear_maid_pos"));
    }
}

