/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.init.InitBlocks;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.item.MaidGroup;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityMaidBeacon;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.text.DecimalFormat;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.TallBlockItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemMaidBeacon
extends TallBlockItem {
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.00");
    private static final String STORAGE_DATA_TAG = "StorageData";
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;

    public ItemMaidBeacon() {
        super((Block)InitBlocks.MAID_BEACON.get(), new Item.Properties().func_200917_a(1).func_200916_a(MaidGroup.MAIN_TAB));
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Tool modifier", 3.0, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Tool modifier", -3.2, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    public static ItemStack tileEntityToItemStack(TileEntityMaidBeacon beacon) {
        ItemStack stack = ((Item)InitItems.MAID_BEACON.get()).func_190903_i();
        CompoundNBT stackTag = stack.func_196082_o();
        stackTag.func_218657_a(STORAGE_DATA_TAG, (INBT)beacon.func_189515_b(new CompoundNBT()));
        return stack;
    }

    public static void itemStackToTileEntity(ItemStack stack, TileEntityMaidBeacon beacon) {
        CompoundNBT tag = stack.func_190925_c(STORAGE_DATA_TAG);
        if (tag.func_150297_b("ForgeData", 10)) {
            beacon.loadData(tag.func_74775_l("ForgeData"));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        CompoundNBT forgeTag;
        float numPower = 0.0f;
        CompoundNBT tag = stack.func_190925_c(STORAGE_DATA_TAG);
        if (tag.func_150297_b("ForgeData", 10) && (forgeTag = tag.func_74775_l("ForgeData")).func_150297_b("StoragePower", 5)) {
            numPower = forgeTag.func_74760_g("StoragePower");
        }
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltips.touhou_little_maid.maid_beacon.desc", new Object[]{DECIMAL_FORMAT.format(numPower)}).func_240699_a_(TextFormatting.GRAY));
    }

    public Multimap<Attribute, AttributeModifier> func_111205_h(EquipmentSlotType equipmentSlot) {
        return equipmentSlot == EquipmentSlotType.MAINHAND ? this.defaultModifiers : super.func_111205_h(equipmentSlot);
    }
}

