/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitBlocks;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.item.MaidGroup;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityModelSwitcher;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class ItemModelSwitcher
extends BlockItem {
    private static final String STORAGE_DATA_TAG = "StorageData";
    private static final String FORGE_DATA_TAG = "ForgeData";

    public ItemModelSwitcher() {
        super((Block)InitBlocks.MODEL_SWITCHER.get(), new Item.Properties().func_200917_a(1).func_200916_a(MaidGroup.MAIN_TAB));
    }

    public static ItemStack tileEntityToItemStack(TileEntityModelSwitcher switcher) {
        ItemStack stack = ((Item)InitItems.MODEL_SWITCHER.get()).func_190903_i();
        CompoundNBT stackTag = stack.func_196082_o();
        stackTag.func_218657_a(STORAGE_DATA_TAG, (INBT)switcher.func_189515_b(new CompoundNBT()));
        return stack;
    }

    public static void itemStackToTileEntity(ItemStack stack, TileEntityModelSwitcher switcher) {
        CompoundNBT tag = stack.func_190925_c(STORAGE_DATA_TAG);
        if (tag.func_150297_b(FORGE_DATA_TAG, 10)) {
            switcher.func_230337_a_(switcher.func_195044_w(), tag);
        }
    }

    public ActionResultType func_111207_a(ItemStack pStack, PlayerEntity pPlayer, LivingEntity pInteractionTarget, Hand pUsedHand) {
        if (pInteractionTarget instanceof EntityMaid) {
            EntityMaid maid = (EntityMaid)pInteractionTarget;
            CompoundNBT tag = pStack.func_190925_c(STORAGE_DATA_TAG);
            CompoundNBT forgeData = tag.func_150297_b(FORGE_DATA_TAG, 10) ? tag.func_74775_l(FORGE_DATA_TAG) : new CompoundNBT();
            forgeData.func_218657_a("entity_uuid", (INBT)NBTUtil.func_240626_a_((UUID)maid.func_110124_au()));
            tag.func_218657_a(FORGE_DATA_TAG, (INBT)forgeData);
            return ActionResultType.SUCCESS;
        }
        return super.func_111207_a(pStack, pPlayer, pInteractionTarget, pUsedHand);
    }

    private boolean hasMaidInfo(ItemStack stack) {
        CompoundNBT tag = stack.func_179543_a(STORAGE_DATA_TAG);
        if (tag != null && tag.func_150297_b(FORGE_DATA_TAG, 10)) {
            CompoundNBT forgeTag = tag.func_74775_l(FORGE_DATA_TAG);
            return forgeTag.func_150297_b("entity_uuid", 11);
        }
        return false;
    }

    public void func_77624_a(ItemStack pStack, @Nullable World pLevel, List<ITextComponent> pTooltip, ITooltipFlag pFlag) {
        if (this.hasMaidInfo(pStack)) {
            pTooltip.add((ITextComponent)new TranslationTextComponent("tooltips.touhou_little_maid.model_switcher.bounded").func_240699_a_(TextFormatting.GRAY));
        } else {
            pTooltip.add((ITextComponent)new TranslationTextComponent("gui.touhou_little_maid.model_switcher.uuid.empty").func_240699_a_(TextFormatting.DARK_RED));
        }
    }
}

