/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.item.MaidGroup;
import com.github.tartaricacid.touhoulittlemaid.util.ParseI18n;
import com.github.tartaricacid.touhoulittlemaid.util.PlaceHelper;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.apache.commons.lang3.StringUtils;

public class ItemPhoto
extends Item {
    private static final String MAID_INFO = "MaidInfo";

    public ItemPhoto() {
        super(new Item.Properties().func_200916_a(MaidGroup.MAIN_TAB).func_200917_a(1));
    }

    public static boolean hasMaidData(ItemStack stack) {
        return stack.func_77942_o() && !Objects.requireNonNull(stack.func_77978_p()).func_74775_l(MAID_INFO).isEmpty();
    }

    public static CompoundNBT getMaidData(ItemStack stack) {
        if (ItemPhoto.hasMaidData(stack)) {
            return Objects.requireNonNull(stack.func_77978_p()).func_74775_l(MAID_INFO);
        }
        return new CompoundNBT();
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        Direction facing = context.func_196000_l();
        World worldIn = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        PlayerEntity player = context.func_195999_j();
        ItemStack photo = context.func_195996_i();
        Vector3d clickLocation = context.func_221532_j();
        if (player == null) {
            return super.func_195939_a(context);
        }
        if (facing != Direction.UP || PlaceHelper.notSuitableForPlaceMaid(worldIn, pos)) {
            if (worldIn.field_72995_K) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("message.touhou_little_maid.photo.not_suitable_for_place_maid"), Util.field_240973_b_);
            }
            return ActionResultType.FAIL;
        }
        if (!ItemPhoto.hasMaidData(photo)) {
            if (worldIn.field_72995_K) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("message.touhou_little_maid.photo.have_no_nbt_data"), Util.field_240973_b_);
            }
            return ActionResultType.FAIL;
        }
        Optional entityOptional = EntityType.func_220330_a((CompoundNBT)ItemPhoto.getMaidData(photo), (World)worldIn);
        if (entityOptional.isPresent() && entityOptional.get() instanceof EntityMaid) {
            EntityMaid maid = (EntityMaid)((Object)entityOptional.get());
            maid.func_70107_b(clickLocation.field_72450_a, clickLocation.field_72448_b, clickLocation.field_72449_c);
            if (!worldIn.field_72995_K) {
                worldIn.func_217376_c((Entity)maid);
            }
            maid.spawnExplosionParticle();
            photo.func_190918_g(1);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        if (!entity.func_190530_aW()) {
            entity.func_184224_h(true);
        }
        Vector3d position = entity.func_213303_ch();
        if (position.field_72448_b < 0.0) {
            entity.func_189654_d(true);
            entity.func_213317_d(Vector3d.field_186680_a);
            entity.func_70107_b(position.field_72450_a, 0.0, position.field_72449_c);
        }
        return super.onEntityItemUpdate(stack, entity);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (!ItemPhoto.hasMaidData(stack)) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltips.touhou_little_maid.photo.no_data.desc").func_240699_a_(TextFormatting.DARK_RED));
        } else {
            String modelId;
            CompoundNBT maidData = ItemPhoto.getMaidData(stack);
            if (maidData.func_150297_b("ModelId", 8) && StringUtils.isNotBlank((CharSequence)(modelId = maidData.func_74779_i("ModelId")))) {
                CustomPackLoader.MAID_MODELS.getInfo(modelId).ifPresent(modelItem -> tooltip.add((ITextComponent)new TranslationTextComponent("tooltips.touhou_little_maid.photo.maid.desc", new Object[]{I18n.func_135052_a((String)ParseI18n.getI18nKey(modelItem.getName()), (Object[])new Object[0])}).func_240699_a_(TextFormatting.GRAY)));
            }
        }
    }
}

