/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.capability.MaidNumCapabilityProvider;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.item.MaidGroup;
import com.github.tartaricacid.touhoulittlemaid.util.ParseI18n;
import com.github.tartaricacid.touhoulittlemaid.util.PlaceHelper;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.StringUtils;

public class ItemSmartSlab
extends Item {
    private static final String MAID_INFO = "MaidInfo";
    private static final String MAID_OWNER = "Owner";
    private final Type type;

    public ItemSmartSlab(Type type) {
        super(new Item.Properties().func_200916_a(MaidGroup.MAIN_TAB).func_200917_a(1));
        this.type = type;
    }

    public static void storeMaidData(ItemStack stack, EntityMaid maid) {
        maid.func_189511_e(stack.func_190925_c(MAID_INFO));
    }

    public static boolean hasMaidData(ItemStack stack) {
        return stack.func_77942_o() && !Objects.requireNonNull(stack.func_77978_p()).func_74775_l(MAID_INFO).isEmpty();
    }

    public static CompoundNBT getMaidData(ItemStack stack) {
        if (ItemSmartSlab.hasMaidData(stack)) {
            return Objects.requireNonNull(stack.func_77978_p()).func_74775_l(MAID_INFO);
        }
        return new CompoundNBT();
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group) && this.type == Type.INIT) {
            items.add((Object)new ItemStack((IItemProvider)this));
        }
    }

    public String func_77658_a() {
        return "item.touhou_little_maid.smart_slab";
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        Direction clickedFace = context.func_196000_l();
        PlayerEntity player = context.func_195999_j();
        World worldIn = context.func_195991_k();
        BlockPos clickedPos = context.func_195995_a();
        if (player == null) {
            return super.func_195939_a(context);
        }
        if (clickedFace == Direction.UP && !PlaceHelper.notSuitableForPlaceMaid(worldIn, clickedPos)) {
            EntityMaid maid = (EntityMaid)((EntityType)InitEntities.MAID.get()).func_200721_a(worldIn);
            if (maid == null) {
                return super.func_195939_a(context);
            }
            if (this.type == Type.INIT) {
                return this.spawnNewMaid(context, player, worldIn, maid);
            }
            if (this.type == Type.HAS_MAID) {
                return this.spawnFromStore(context, player, worldIn, maid);
            }
        } else if (worldIn.field_72995_K) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("message.touhou_little_maid.photo.not_suitable_for_place_maid"), Util.field_240973_b_);
        }
        return super.func_195939_a(context);
    }

    private ActionResultType spawnFromStore(ItemUseContext context, PlayerEntity player, World worldIn, EntityMaid maid) {
        ItemStack stack = context.func_195996_i();
        if (ItemSmartSlab.hasMaidData(stack)) {
            CompoundNBT maidData = ItemSmartSlab.getMaidData(stack);
            UUID ownerUid = maidData.func_186857_a(MAID_OWNER);
            if (!player.func_110124_au().equals(ownerUid)) {
                return ActionResultType.FAIL;
            }
            maid.func_70020_e(maidData);
            maid.func_174828_a(context.func_195995_a().func_177984_a(), 0.0f, 0.0f);
            if (worldIn instanceof ServerWorld) {
                worldIn.func_217376_c((Entity)maid);
            }
            maid.spawnExplosionParticle();
            maid.func_184185_a(SoundEvents.field_187806_ee, 1.0f, worldIn.field_73012_v.nextFloat() * 0.1f + 0.9f);
            player.func_184611_a(context.func_221531_n(), ((Item)InitItems.SMART_SLAB_EMPTY.get()).func_190903_i());
            player.func_184811_cZ().func_185145_a((Item)InitItems.SMART_SLAB_EMPTY.get(), 20);
            return ActionResultType.func_233537_a_((boolean)worldIn.field_72995_K);
        }
        return super.func_195939_a(context);
    }

    private ActionResultType spawnNewMaid(ItemUseContext context, PlayerEntity player, World worldIn, EntityMaid maid) {
        return player.getCapability(MaidNumCapabilityProvider.MAID_NUM_CAP).map(cap -> {
            if (cap.canAdd() || player.func_184812_l_()) {
                if (!player.func_184812_l_()) {
                    cap.add();
                }
                maid.func_193101_c(player);
                if (worldIn instanceof ServerWorld) {
                    maid.func_213386_a((IServerWorld)((ServerWorld)worldIn), worldIn.func_175649_E(context.func_195995_a()), SpawnReason.SPAWN_EGG, null, null);
                    maid.func_174828_a(context.func_195995_a().func_177984_a(), 0.0f, 0.0f);
                    worldIn.func_217376_c((Entity)maid);
                }
                maid.spawnExplosionParticle();
                maid.func_184185_a(SoundEvents.field_187806_ee, 1.0f, worldIn.field_73012_v.nextFloat() * 0.1f + 0.9f);
                player.func_184611_a(context.func_221531_n(), ((Item)InitItems.SMART_SLAB_EMPTY.get()).func_190903_i());
                player.func_184811_cZ().func_185145_a((Item)InitItems.SMART_SLAB_EMPTY.get(), 20);
                return ActionResultType.func_233537_a_((boolean)worldIn.field_72995_K);
            }
            if (worldIn.field_72995_K) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("message.touhou_little_maid.owner_maid_num.can_not_add", new Object[]{cap.get(), cap.getMaxNum()}), Util.field_240973_b_);
            }
            return super.func_195939_a(context);
        }).orElse(super.func_195939_a(context));
    }

    public boolean func_77636_d(ItemStack stack) {
        return this.type != Type.EMPTY;
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        if (!entity.func_190530_aW()) {
            entity.func_184224_h(true);
        }
        Vector3d position = entity.func_213303_ch();
        if (position.field_72448_b < 0.0) {
            entity.func_189654_d(true);
            entity.func_213317_d(Vector3d.field_186680_a);
            entity.func_70107_b(position.field_72450_a, 0.0, position.field_72449_c);
        }
        return super.onEntityItemUpdate(stack, entity);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        String modelId;
        CompoundNBT maidData;
        if (this.type == Type.INIT) {
            TranslationTextComponent text = new TranslationTextComponent("tooltips.touhou_little_maid.smart_slab.maid_name", new Object[]{I18n.func_135052_a((String)"tooltips.touhou_little_maid.smart_slab.maid_name.unknown", (Object[])new Object[0])});
            tooltip.add((ITextComponent)text.func_240699_a_(TextFormatting.GRAY));
        }
        if (this.type == Type.HAS_MAID && (maidData = ItemSmartSlab.getMaidData(stack)).func_150297_b("ModelId", 8) && StringUtils.isNotBlank((CharSequence)(modelId = ItemSmartSlab.getMaidData(stack).func_74779_i("ModelId")))) {
            CustomPackLoader.MAID_MODELS.getInfo(modelId).ifPresent(info -> {
                String modelNameKey = ParseI18n.getI18nKey(info.getName());
                TranslationTextComponent text = new TranslationTextComponent("tooltips.touhou_little_maid.smart_slab.maid_name", new Object[]{I18n.func_135052_a((String)modelNameKey, (Object[])new Object[0])});
                tooltip.add((ITextComponent)text.func_240699_a_(TextFormatting.GRAY));
            });
        }
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltips.touhou_little_maid.smart_slab.desc").func_240699_a_(TextFormatting.GRAY));
    }

    public static enum Type {
        INIT,
        EMPTY,
        HAS_MAID;

    }
}

