/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.item.MaidGroup;
import com.github.tartaricacid.touhoulittlemaid.world.data.MaidInfo;
import com.github.tartaricacid.touhoulittlemaid.world.data.MaidWorldData;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class ItemTrumpet
extends Item {
    private static final int MIN_USE_DURATION = 20;

    public ItemTrumpet() {
        super(new Item.Properties().func_200916_a(MaidGroup.MAIN_TAB).func_200917_a(1));
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof PlayerEntity && timeLeft >= 20) {
            PlayerEntity player = (PlayerEntity)entityLiving;
            if (worldIn instanceof ServerWorld) {
                List<MaidInfo> infos;
                ((ServerWorld)worldIn).getEntities().filter(Entity::func_70089_S).filter(e -> e instanceof EntityMaid).filter(e -> ((EntityMaid)((Object)e)).func_152114_e((LivingEntity)player)).forEach(e -> this.teleportToOwner((EntityMaid)((Object)e), player));
                MaidWorldData data = MaidWorldData.get(worldIn);
                if (data != null && (infos = data.getPlayerMaidInfos(player)) != null && !infos.isEmpty()) {
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("message.touhou_little_maid.trumpet.unloaded_maid", new Object[]{infos.size()}).func_240699_a_(TextFormatting.DARK_RED), Util.field_240973_b_);
                }
            }
            player.func_184811_cZ().func_185145_a((Item)this, 200);
        }
    }

    private void teleportToOwner(EntityMaid maid, PlayerEntity player) {
        maid.setHomeModeEnable(false);
        maid.func_70634_a(player.func_226277_ct_() + (double)field_77697_d.nextInt(3) - 1.0, player.func_226278_cu_(), player.func_226281_cx_() + (double)field_77697_d.nextInt(3) - 1.0);
    }

    public int func_77626_a(ItemStack stack) {
        return 100;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        playerIn.func_184598_c(handIn);
        return ActionResult.func_226249_b_((Object)stack);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltips.touhou_little_maid.trumpet.desc.usage").func_240699_a_(TextFormatting.GRAY));
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltips.touhou_little_maid.trumpet.desc.note").func_240699_a_(TextFormatting.DARK_RED));
    }
}

