/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.compat.ironchest.IronChestCheck;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.WirelessIOContainer;
import com.github.tartaricacid.touhoulittlemaid.item.MaidGroup;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.ByteArrayNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.ItemStackHandler;

public class ItemWirelessIO
extends Item
implements INamedContainerProvider {
    private static final int FILTER_LIST_SIZE = 9;
    private static final String FILTER_LIST_TAG = "ItemFilterList";
    private static final String FILTER_MODE_TAG = "ItemFilterMode";
    private static final String IO_MODE_TAG = "ItemIOMode";
    private static final String BINDING_POS = "BindingPos";
    private static final String SLOT_CONFIG_TAG = "SlotConfigData";
    private static final String TOOLTIPS_PREFIX = "\u00a7a\u258d \u00a77";

    public ItemWirelessIO() {
        super(new Item.Properties().func_200916_a(MaidGroup.MAIN_TAB).func_200917_a(1));
    }

    public static void setMode(ItemStack stack, boolean maidToChest) {
        if (stack.func_77973_b() == InitItems.WIRELESS_IO.get()) {
            stack.func_196082_o().func_74757_a(IO_MODE_TAG, maidToChest);
        }
    }

    public static boolean isMaidToChest(ItemStack stack) {
        if (stack.func_77973_b() == InitItems.WIRELESS_IO.get() && stack.func_77942_o()) {
            CompoundNBT nbt = stack.func_77978_p();
            return Objects.requireNonNull(nbt).func_74767_n(IO_MODE_TAG);
        }
        return false;
    }

    public static void setFilterMode(ItemStack stack, boolean isBlacklist) {
        if (stack.func_77973_b() == InitItems.WIRELESS_IO.get()) {
            stack.func_196082_o().func_74757_a(FILTER_MODE_TAG, isBlacklist);
        }
    }

    public static boolean isBlacklist(ItemStack stack) {
        if (stack.func_77973_b() == InitItems.WIRELESS_IO.get() && stack.func_77942_o()) {
            CompoundNBT nbt = stack.func_77978_p();
            return Objects.requireNonNull(nbt).func_74767_n(FILTER_MODE_TAG);
        }
        return false;
    }

    public static ItemStackHandler getFilterList(ItemStack stack) {
        CompoundNBT tag;
        WirelessIOHandler handler = new WirelessIOHandler(9);
        if (stack.func_77973_b() == InitItems.WIRELESS_IO.get() && (tag = stack.func_77978_p()) != null && tag.func_150297_b(FILTER_LIST_TAG, 10)) {
            handler.deserializeNBT(tag.func_74775_l(FILTER_LIST_TAG));
        }
        return handler;
    }

    public static void setFilterList(ItemStack stack, ItemStackHandler itemStackHandler) {
        if (stack.func_77973_b() == InitItems.WIRELESS_IO.get()) {
            stack.func_196082_o().func_218657_a(FILTER_LIST_TAG, (INBT)itemStackHandler.serializeNBT());
        }
    }

    @Nullable
    public static BlockPos getBindingPos(ItemStack stack) {
        CompoundNBT tag;
        if (stack.func_77973_b() == InitItems.WIRELESS_IO.get() && (tag = stack.func_77978_p()) != null && tag.func_150297_b(BINDING_POS, 10)) {
            return NBTUtil.func_186861_c((CompoundNBT)tag.func_74775_l(BINDING_POS));
        }
        return null;
    }

    public static void setBindingPos(ItemStack stack, BlockPos pos) {
        if (stack.func_77973_b() == InitItems.WIRELESS_IO.get()) {
            stack.func_196082_o().func_218657_a(BINDING_POS, (INBT)NBTUtil.func_186859_a((BlockPos)pos));
        }
    }

    public static void setSlotConfig(ItemStack stack, byte[] config) {
        if (stack.func_77973_b() == InitItems.WIRELESS_IO.get()) {
            stack.func_196082_o().func_218657_a(SLOT_CONFIG_TAG, (INBT)new ByteArrayNBT(config));
        }
    }

    @Nullable
    public static byte[] getSlotConfig(ItemStack stack) {
        CompoundNBT tag;
        if (stack.func_77973_b() == InitItems.WIRELESS_IO.get() && (tag = stack.func_77978_p()) != null && tag.func_150297_b(SLOT_CONFIG_TAG, 7)) {
            return tag.func_74770_j(SLOT_CONFIG_TAG);
        }
        return null;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        LockableLootTileEntity chest;
        World worldIn = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        PlayerEntity player = context.func_195999_j();
        Hand hand = context.func_221531_n();
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof LockableLootTileEntity && player != null && (te instanceof ChestTileEntity || IronChestCheck.isIronChest(te)) && (chest = (LockableLootTileEntity)te).func_213904_e(player) && hand == Hand.MAIN_HAND) {
            ItemStack stack = player.func_184614_ca();
            ItemWirelessIO.setBindingPos(stack, pos);
            return ActionResultType.func_233537_a_((boolean)worldIn.field_72995_K);
        }
        return super.func_195939_a(context);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        if (handIn == Hand.MAIN_HAND && playerIn instanceof ServerPlayerEntity) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)playerIn), (INamedContainerProvider)this, buffer -> buffer.func_150788_a(playerIn.func_184614_ca()));
            return ActionResult.func_226248_a_((Object)playerIn.func_184614_ca());
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        boolean maidToChest = ItemWirelessIO.isMaidToChest(stack);
        boolean isBlacklist = ItemWirelessIO.isBlacklist(stack);
        BlockPos pos = ItemWirelessIO.getBindingPos(stack);
        String ioModeText = maidToChest ? I18n.func_135052_a((String)"tooltips.touhou_little_maid.wireless_io.io_mode.input", (Object[])new Object[0]) : I18n.func_135052_a((String)"tooltips.touhou_little_maid.wireless_io.io_mode.output", (Object[])new Object[0]);
        String filterModeText = isBlacklist ? I18n.func_135052_a((String)"tooltips.touhou_little_maid.wireless_io.filter_mode.blacklist", (Object[])new Object[0]) : I18n.func_135052_a((String)"tooltips.touhou_little_maid.wireless_io.filter_mode.whitelist", (Object[])new Object[0]);
        String hasPos = pos != null ? I18n.func_135052_a((String)"tooltips.touhou_little_maid.wireless_io.binding_pos.has", (Object[])new Object[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()}) : I18n.func_135052_a((String)"tooltips.touhou_little_maid.wireless_io.binding_pos.none", (Object[])new Object[0]);
        tooltip.add((ITextComponent)new StringTextComponent(TOOLTIPS_PREFIX + ioModeText));
        tooltip.add((ITextComponent)new StringTextComponent(TOOLTIPS_PREFIX + filterModeText));
        tooltip.add((ITextComponent)new StringTextComponent(TOOLTIPS_PREFIX + hasPos));
        tooltip.add((ITextComponent)new StringTextComponent(" "));
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltips.touhou_little_maid.wireless_io.usage.1").func_240699_a_(TextFormatting.GRAY));
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltips.touhou_little_maid.wireless_io.usage.2").func_240699_a_(TextFormatting.GRAY));
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("item.touhou_little_maid.wireless_io");
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory inventory, PlayerEntity player) {
        return new WirelessIOContainer(id, inventory, player.func_184614_ca());
    }

    private static class WirelessIOHandler
    extends ItemStackHandler {
        private WirelessIOHandler(int size) {
            super(size);
        }

        public int getSlotLimit(int slot) {
            return 1;
        }
    }
}

