/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item.bauble;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.ILittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.bauble.IMaidBauble;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.item.bauble.DrownProtectBauble;
import com.github.tartaricacid.touhoulittlemaid.item.bauble.ExplosionProtectBauble;
import com.github.tartaricacid.touhoulittlemaid.item.bauble.ExtraLifeBauble;
import com.github.tartaricacid.touhoulittlemaid.item.bauble.FallProtectBauble;
import com.github.tartaricacid.touhoulittlemaid.item.bauble.FireProtectBauble;
import com.github.tartaricacid.touhoulittlemaid.item.bauble.ItemMagnetBauble;
import com.github.tartaricacid.touhoulittlemaid.item.bauble.MagicProtectBauble;
import com.github.tartaricacid.touhoulittlemaid.item.bauble.MuteBauble;
import com.github.tartaricacid.touhoulittlemaid.item.bauble.NimbleFabricBauble;
import com.github.tartaricacid.touhoulittlemaid.item.bauble.ProjectileProtectBauble;
import com.github.tartaricacid.touhoulittlemaid.item.bauble.UndyingTotemBauble;
import com.github.tartaricacid.touhoulittlemaid.item.bauble.WirelessIOBauble;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.RegistryObject;

public final class BaubleManager {
    private static Map<RegistryObject<Item>, IMaidBauble> BAUBLES;

    private BaubleManager() {
        BAUBLES = Maps.newHashMap();
    }

    public static void init() {
        BaubleManager manager = new BaubleManager();
        manager.bind(InitItems.DROWN_PROTECT_BAUBLE, (IMaidBauble)new DrownProtectBauble());
        manager.bind(InitItems.EXPLOSION_PROTECT_BAUBLE, (IMaidBauble)new ExplosionProtectBauble());
        manager.bind(InitItems.ULTRAMARINE_ORB_ELIXIR, (IMaidBauble)new ExtraLifeBauble());
        manager.bind(InitItems.FALL_PROTECT_BAUBLE, (IMaidBauble)new FallProtectBauble());
        manager.bind(InitItems.FIRE_PROTECT_BAUBLE, (IMaidBauble)new FireProtectBauble());
        manager.bind(InitItems.ITEM_MAGNET_BAUBLE, (IMaidBauble)new ItemMagnetBauble());
        manager.bind(InitItems.MAGIC_PROTECT_BAUBLE, (IMaidBauble)new MagicProtectBauble());
        manager.bind(InitItems.NIMBLE_FABRIC, (IMaidBauble)new NimbleFabricBauble());
        manager.bind(InitItems.PROJECTILE_PROTECT_BAUBLE, (IMaidBauble)new ProjectileProtectBauble());
        manager.bind(InitItems.MUTE_BAUBLE, (IMaidBauble)new MuteBauble());
        manager.bind(Items.field_190929_cY, (IMaidBauble)new UndyingTotemBauble());
        manager.bind(InitItems.WIRELESS_IO, (IMaidBauble)new WirelessIOBauble());
        for (ILittleMaid littleMaid : TouhouLittleMaid.EXTENSIONS) {
            littleMaid.bindMaidBauble(manager);
        }
        BAUBLES = ImmutableMap.copyOf(BAUBLES);
    }

    @Nullable
    public static IMaidBauble getBauble(RegistryObject<Item> item) {
        return BAUBLES.get(item);
    }

    @Nullable
    public static IMaidBauble getBauble(ItemStack stack) {
        Item item = stack.func_77973_b();
        return BaubleManager.getBauble((RegistryObject<Item>)RegistryObject.of((ResourceLocation)item.getRegistryName(), () -> ((Item)item).getRegistryType()));
    }

    public void bind(RegistryObject<Item> item, IMaidBauble bauble) {
        BAUBLES.put(item, bauble);
    }

    public void bind(Item item, IMaidBauble bauble) {
        BAUBLES.put((RegistryObject<Item>)RegistryObject.of((ResourceLocation)item.getRegistryName(), () -> ((Item)item).getRegistryType()), bauble);
    }
}

