/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item.bauble;

import com.github.tartaricacid.touhoulittlemaid.api.bauble.IMaidBauble;
import com.github.tartaricacid.touhoulittlemaid.compat.ironchest.IronChestCheck;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.item.ItemWirelessIO;
import com.github.tartaricacid.touhoulittlemaid.util.BytesBooleansConvert;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class WirelessIOBauble
implements IMaidBauble {
    private static final int SLOT_NUM = 38;

    @Nonnull
    public static ItemStack insertItemStacked(IItemHandler inventory, @Nonnull ItemStack stack, boolean simulate, @Nullable boolean[] slotConfig) {
        int i;
        if (stack.func_190926_b()) {
            return stack;
        }
        if (!stack.func_77985_e()) {
            return WirelessIOBauble.insertItem(inventory, stack, simulate, slotConfig);
        }
        int sizeInventory = inventory.getSlots();
        for (i = 0; i < sizeInventory; ++i) {
            ItemStack slot = inventory.getStackInSlot(i);
            if ((slotConfig == null || i >= slotConfig.length || !slotConfig[i]) && WirelessIOBauble.canItemStacksStackRelaxed(slot, stack) && (stack = inventory.insertItem(i, stack, simulate)).func_190926_b()) break;
        }
        if (!stack.func_190926_b()) {
            for (i = 0; i < sizeInventory && (slotConfig != null && i < slotConfig.length && slotConfig[i] || !inventory.getStackInSlot(i).func_190926_b() || !(stack = inventory.insertItem(i, stack, simulate)).func_190926_b()); ++i) {
            }
        }
        return stack;
    }

    public static ItemStack insertItem(IItemHandler dest, @Nonnull ItemStack stack, boolean simulate, @Nullable boolean[] slotConfig) {
        if (stack.func_190926_b()) {
            return stack;
        }
        for (int i = 0; i < dest.getSlots(); ++i) {
            if (slotConfig != null && i < slotConfig.length && slotConfig[i] || !(stack = dest.insertItem(i, stack, simulate)).func_190926_b()) continue;
            return ItemStack.field_190927_a;
        }
        return stack;
    }

    public static boolean canItemStacksStackRelaxed(@Nonnull ItemStack a, @Nonnull ItemStack b) {
        if (a.func_190926_b() || b.func_190926_b() || a.func_77973_b() != b.func_77973_b()) {
            return false;
        }
        if (!a.func_77985_e()) {
            return false;
        }
        if (a.func_77942_o() != b.func_77942_o()) {
            return false;
        }
        return (!a.func_77942_o() || Objects.equals(a.func_77978_p(), Objects.requireNonNull(b.func_77978_p()))) && a.areCapsCompatible((CapabilityProvider)b);
    }

    @Override
    public void onTick(EntityMaid maid, ItemStack baubleItem) {
        if (maid.field_70173_aa % 100 == 0 && !maid.guiOpening) {
            BlockPos bindingPos = ItemWirelessIO.getBindingPos(baubleItem);
            if (bindingPos == null) {
                return;
            }
            float maxDistance = maid.func_213391_dJ();
            if (maid.func_70092_e(bindingPos.func_177958_n(), bindingPos.func_177956_o(), bindingPos.func_177952_p()) > (double)(maxDistance * maxDistance)) {
                return;
            }
            TileEntity te = maid.field_70170_p.func_175625_s(bindingPos);
            if (!(te instanceof LockableLootTileEntity)) {
                return;
            }
            int openCount = IronChestCheck.getOpenCount((IBlockReader)maid.field_70170_p, bindingPos, te);
            if (openCount > 0) {
                return;
            }
            LockableLootTileEntity chest = (LockableLootTileEntity)te;
            chest.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).ifPresent(chestInv -> {
                CombinedInvWrapper maidInv = maid.getAvailableInv(false);
                boolean isMaidToChest = ItemWirelessIO.isMaidToChest(baubleItem);
                boolean isBlacklist = ItemWirelessIO.isBlacklist(baubleItem);
                byte[] slotConfigTmp = ItemWirelessIO.getSlotConfig(baubleItem);
                if (slotConfigTmp != null) {
                    slotConfigTmp[maidInv.getSlots() - 2] = slotConfigTmp[36];
                    slotConfigTmp[maidInv.getSlots() - 1] = slotConfigTmp[37];
                }
                boolean[] slotConfigData = BytesBooleansConvert.bytes2Booleans(slotConfigTmp, 38);
                ItemStackHandler filterList = ItemWirelessIO.getFilterList(baubleItem);
                if (isMaidToChest) {
                    this.maidToChest((IItemHandler)maidInv, (IItemHandler)chestInv, isBlacklist, (IItemHandler)filterList, slotConfigData);
                } else {
                    this.chestToMaid((IItemHandler)chestInv, (IItemHandler)maidInv, isBlacklist, (IItemHandler)filterList, slotConfigData);
                }
            });
        }
    }

    private void maidToChest(IItemHandler maid, IItemHandler chest, boolean isBlacklist, IItemHandler filterList, boolean[] slotConfig) {
        for (int i = 0; i < maid.getSlots(); ++i) {
            ItemStack after;
            int afterCount;
            int beforeCount;
            if (i < slotConfig.length && slotConfig[i]) continue;
            ItemStack maidInvItem = maid.getStackInSlot(i);
            boolean allowMove = isBlacklist;
            for (int j = 0; j < filterList.getSlots(); ++j) {
                ItemStack filterItem = filterList.getStackInSlot(j);
                boolean isEqual = maidInvItem.func_185136_b(filterItem);
                if (!isEqual) continue;
                allowMove = !isBlacklist;
                break;
            }
            if (!allowMove || (beforeCount = maidInvItem.func_190916_E()) == (afterCount = (after = ItemHandlerHelper.insertItemStacked((IItemHandler)chest, (ItemStack)maidInvItem.func_77946_l(), (boolean)false)).func_190916_E())) continue;
            maid.extractItem(i, beforeCount - afterCount, false);
        }
    }

    private void chestToMaid(IItemHandler chest, IItemHandler maid, boolean isBlacklist, IItemHandler filterList, boolean[] slotConfig) {
        for (int i = 0; i < chest.getSlots(); ++i) {
            ItemStack after;
            int afterCount;
            int beforeCount;
            ItemStack chestInvStack = chest.getStackInSlot(i);
            boolean allowMove = isBlacklist;
            for (int j = 0; j < filterList.getSlots(); ++j) {
                ItemStack filterItem = filterList.getStackInSlot(j);
                boolean isEqual = chestInvStack.func_185136_b(filterItem);
                if (!isEqual) continue;
                allowMove = !isBlacklist;
                break;
            }
            if (!allowMove || (beforeCount = chestInvStack.func_190916_E()) == (afterCount = (after = WirelessIOBauble.insertItemStacked(maid, chestInvStack.func_77946_l(), false, slotConfig)).func_190916_E())) continue;
            chest.extractItem(i, beforeCount - afterCount, false);
        }
    }
}

