/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.loot;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;

public class AdditionLootModifier
extends LootModifier {
    private final ResourceLocation parameterSet;
    private final ResourceLocation additionLootTable;

    public AdditionLootModifier(ILootCondition[] conditionsIn, ResourceLocation parameterSet, ResourceLocation additionLootTable) {
        super(conditionsIn);
        this.parameterSet = parameterSet;
        this.additionLootTable = additionLootTable;
    }

    @Nonnull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        ResourceLocation currentLootTable = context.getQueriedLootTableId();
        if (!currentLootTable.equals((Object)this.additionLootTable) && this.parameterSetEquals(context)) {
            LootTable additionTable = context.func_227502_a_(this.additionLootTable);
            generatedLoot.addAll(additionTable.func_216113_a(context));
        }
        return generatedLoot;
    }

    private boolean parameterSetEquals(LootContext context) {
        ResourceLocation currentLootTable = context.getQueriedLootTableId();
        LootTable lootTable = context.func_227502_a_(currentLootTable);
        return Objects.equals(lootTable.func_216122_a(), LootParameterSets.func_216256_a((ResourceLocation)this.parameterSet));
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<AdditionLootModifier> {
        public AdditionLootModifier read(ResourceLocation location, JsonObject object, ILootCondition[] conditions) {
            String parameterSet = JSONUtils.func_151200_h((JsonObject)object, (String)"parameter_set_name");
            String additionLootTable = JSONUtils.func_151200_h((JsonObject)object, (String)"addition_loot_table");
            return new AdditionLootModifier(conditions, new ResourceLocation(parameterSet), new ResourceLocation(additionLootTable));
        }

        public JsonObject write(AdditionLootModifier instance) {
            JsonObject object = this.makeConditions(instance.conditions);
            object.addProperty("parameter_set_name", instance.parameterSet.toString());
            object.addProperty("addition_loot_table", instance.additionLootTable.toString());
            return object;
        }
    }
}

