/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.config.subconfig.ChairConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityChair;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.network.NetworkEvent;

public class ChairModelMessage {
    private final int id;
    private final ResourceLocation modelId;
    private final float mountedHeight;
    private final boolean tameableCanRide;
    private final boolean noGravity;

    public ChairModelMessage(int id, ResourceLocation modelId, float mountedHeight, boolean tameableCanRide, boolean noGravity) {
        this.id = id;
        this.modelId = modelId;
        this.mountedHeight = mountedHeight;
        this.tameableCanRide = tameableCanRide;
        this.noGravity = noGravity;
    }

    public static void encode(ChairModelMessage message, PacketBuffer buf) {
        buf.writeInt(message.id);
        buf.func_192572_a(message.modelId);
        buf.writeFloat(message.mountedHeight);
        buf.writeBoolean(message.tameableCanRide);
        buf.writeBoolean(message.noGravity);
    }

    public static ChairModelMessage decode(PacketBuffer buf) {
        return new ChairModelMessage(buf.readInt(), buf.func_192575_l(), buf.readFloat(), buf.readBoolean(), buf.readBoolean());
    }

    public static void handle(ChairModelMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isServer()) {
            context.enqueueWork(() -> {
                boolean canChangeModel;
                ServerPlayerEntity sender = context.getSender();
                if (sender == null) {
                    return;
                }
                Entity entity = sender.field_70170_p.func_73045_a(message.id);
                boolean bl = canChangeModel = (Boolean)ChairConfig.CHAIR_CHANGE_MODEL.get() != false || sender.func_184812_l_();
                if (entity instanceof EntityChair) {
                    if (canChangeModel) {
                        EntityChair chair = (EntityChair)entity;
                        chair.setModelId(message.modelId.toString());
                        chair.setMountedHeight(message.mountedHeight);
                        chair.setTameableCanRide(message.tameableCanRide);
                        chair.func_189654_d(message.noGravity);
                        if (!message.tameableCanRide && !chair.func_184188_bt().isEmpty()) {
                            chair.func_184226_ay();
                        }
                    } else if (sender.func_70089_S()) {
                        sender.func_241151_a_((ITextComponent)new TranslationTextComponent("message.touhou_little_maid.change_model.disabled"), ChatType.GAME_INFO, Util.field_240973_b_);
                    }
                }
            });
        }
    }
}

