/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.api.game.gomoku.Point;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.MaidGomokuAI;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.ChessDataToServerMessage;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkEvent;

public class ChessDataToClientMessage {
    private final BlockPos pos;
    private final int[][] chessData;
    private final Point point;
    private final int count;

    public ChessDataToClientMessage(BlockPos pos, int[][] chessData, Point point, int count) {
        this.pos = pos;
        this.chessData = chessData;
        this.point = point;
        this.count = count;
    }

    public static void encode(ChessDataToClientMessage message, PacketBuffer buf) {
        buf.func_179255_a(message.pos);
        buf.func_150787_b(message.chessData.length);
        for (int[] row : message.chessData) {
            buf.func_186875_a(row);
        }
        buf.func_150787_b(message.point.x);
        buf.func_150787_b(message.point.y);
        buf.func_150787_b(message.point.type);
        buf.func_150787_b(message.count);
    }

    public static ChessDataToClientMessage decode(PacketBuffer buf) {
        BlockPos blockPos = buf.func_179259_c();
        int length = buf.func_150792_a();
        int[][] chessData = new int[length][length];
        for (int i = 0; i < length; ++i) {
            chessData[i] = buf.func_186863_b();
        }
        Point pointIn = new Point(buf.func_150792_a(), buf.func_150792_a(), buf.func_150792_a());
        int count = buf.func_150792_a();
        return new ChessDataToClientMessage(blockPos, chessData, pointIn, count);
    }

    public static void handle(ChessDataToClientMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isClient()) {
            context.enqueueWork(() -> CompletableFuture.runAsync(() -> ChessDataToClientMessage.onHandle(message), Util.func_215072_e()));
        }
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void onHandle(ChessDataToClientMessage message) {
        Point aiPoint = MaidGomokuAI.getService(message.count).getPoint(message.chessData, message.point);
        int time = (int)(Math.random() * 1250.0) + 250;
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        Minecraft.func_71410_x().func_213165_a(() -> NetworkHandler.CHANNEL.sendToServer((Object)new ChessDataToServerMessage(message.pos, aiPoint)));
    }
}

