/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.api.game.gomoku.Point;
import com.github.tartaricacid.touhoulittlemaid.api.game.gomoku.Statue;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.MaidGomokuAI;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntitySit;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityGomoku;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;

public class ChessDataToServerMessage {
    private final BlockPos pos;
    private final Point point;

    public ChessDataToServerMessage(BlockPos pos, Point point) {
        this.pos = pos;
        this.point = point;
    }

    public static void encode(ChessDataToServerMessage message, PacketBuffer buf) {
        buf.func_179255_a(message.pos);
        buf.func_150787_b(message.point.x);
        buf.func_150787_b(message.point.y);
        buf.func_150787_b(message.point.type);
    }

    public static ChessDataToServerMessage decode(PacketBuffer buf) {
        BlockPos blockPos = buf.func_179259_c();
        Point pointIn = new Point(buf.func_150792_a(), buf.func_150792_a(), buf.func_150792_a());
        return new ChessDataToServerMessage(blockPos, pointIn);
    }

    public static void handle(ChessDataToServerMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isServer()) {
            context.enqueueWork(() -> {
                ServerPlayerEntity sender = context.getSender();
                if (sender == null) {
                    return;
                }
                World level = sender.field_70170_p;
                if (!level.func_195588_v(message.pos)) {
                    return;
                }
                if (level.func_175625_s(message.pos) instanceof TileEntityGomoku) {
                    Entity firstPassenger;
                    ServerWorld serverWorld;
                    Entity entity;
                    TileEntityGomoku gomoku = (TileEntityGomoku)level.func_175625_s(message.pos);
                    if (!gomoku.isInProgress() || gomoku.isPlayerTurn() || gomoku.getChessCounter() <= 0) {
                        return;
                    }
                    Point aiPoint = message.point;
                    gomoku.setChessData(aiPoint.x, aiPoint.y, aiPoint.type);
                    if (level instanceof ServerWorld && (entity = (serverWorld = (ServerWorld)level).func_217461_a(gomoku.getSitId())) instanceof EntitySit && (firstPassenger = ((EntitySit)entity).getFirstPassenger()) instanceof EntityMaid) {
                        ((EntityMaid)firstPassenger).func_184609_a(Hand.MAIN_HAND);
                    }
                    gomoku.setInProgress(MaidGomokuAI.getStatue(gomoku.getChessData(), aiPoint) == Statue.IN_PROGRESS);
                    level.func_184133_a(null, message.pos, (SoundEvent)InitSounds.GOMOKU.get(), SoundCategory.BLOCKS, 1.0f, 0.8f + level.field_73012_v.nextFloat() * 0.4f);
                    if (gomoku.isInProgress()) {
                        gomoku.setPlayerTurn(true);
                    }
                    gomoku.refresh();
                }
            });
        }
        context.setPacketHandled(true);
    }
}

