/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.client.gui.item.FoxScrollScreen;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkEvent;

public class FoxScrollMessage {
    private final Map<String, List<FoxScrollData>> data;

    public FoxScrollMessage(Map<String, List<FoxScrollData>> data) {
        this.data = data;
    }

    public static void encode(FoxScrollMessage message, PacketBuffer buf) {
        buf.func_150787_b(message.data.size());
        message.data.forEach((dim, scrollData) -> {
            buf.func_150787_b(scrollData.size());
            buf.func_180714_a(dim);
            scrollData.forEach(data -> FoxScrollData.encode(data, buf));
        });
    }

    public static FoxScrollMessage decode(PacketBuffer buf) {
        HashMap data = Maps.newHashMap();
        int dimLength = buf.func_150792_a();
        for (int i = 0; i < dimLength; ++i) {
            ArrayList scrollData = Lists.newArrayList();
            int dataLength = buf.func_150792_a();
            String dim = buf.func_218666_n();
            for (int j = 0; j < dataLength; ++j) {
                scrollData.add(FoxScrollData.decode(buf));
            }
            data.put(dim, scrollData);
        }
        return new FoxScrollMessage(data);
    }

    public static void handle(FoxScrollMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isClient()) {
            context.enqueueWork(() -> FoxScrollMessage.onHandle(message));
        }
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void onHandle(FoxScrollMessage message) {
        Minecraft.func_71410_x().func_147108_a((Screen)new FoxScrollScreen(message.data));
    }

    public static class FoxScrollData {
        private final BlockPos pos;
        private final ITextComponent name;
        private final long timestamp;

        public FoxScrollData(BlockPos pos, ITextComponent name, long timestamp) {
            this.pos = pos;
            this.name = name;
            this.timestamp = timestamp;
        }

        public static void encode(FoxScrollData data, PacketBuffer buf) {
            buf.func_179255_a(data.pos);
            buf.func_179256_a(data.name);
            buf.writeLong(data.timestamp);
        }

        public static FoxScrollData decode(PacketBuffer buf) {
            return new FoxScrollData(buf.func_179259_c(), buf.func_179258_d(), buf.readLong());
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public ITextComponent getName() {
            return this.name;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }
}

