/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkEvent;

public class ItemBreakMessage {
    private final int id;
    private final ItemStack item;

    public ItemBreakMessage(int id, ItemStack item) {
        this.id = id;
        this.item = item;
    }

    public static void encode(ItemBreakMessage message, PacketBuffer buf) {
        buf.writeInt(message.id);
        buf.func_150788_a(message.item);
    }

    public static ItemBreakMessage decode(PacketBuffer buf) {
        return new ItemBreakMessage(buf.readInt(), buf.func_150791_c());
    }

    public static void handle(ItemBreakMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isClient()) {
            context.enqueueWork(() -> ItemBreakMessage.handleBreakItem(message));
        }
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleBreakItem(ItemBreakMessage message) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e == null) {
            return;
        }
        Entity e = mc.field_71441_e.func_73045_a(message.id);
        if (e instanceof LivingEntity && e.func_70089_S()) {
            ((LivingEntity)e).func_70669_a(message.item);
        }
    }
}

