/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.MaidSchedule;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntitySit;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.CheckSchedulePosMessage;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.BrainUtil;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.network.NetworkEvent;

public class MaidConfigMessage {
    private final int id;
    private final boolean home;
    private final boolean pick;
    private final boolean ride;
    private final MaidSchedule schedule;

    public MaidConfigMessage(int id, boolean home, boolean pick, boolean ride, MaidSchedule schedule) {
        this.id = id;
        this.home = home;
        this.pick = pick;
        this.ride = ride;
        this.schedule = schedule;
    }

    public static void encode(MaidConfigMessage message, PacketBuffer buf) {
        buf.writeInt(message.id);
        buf.writeBoolean(message.home);
        buf.writeBoolean(message.pick);
        buf.writeBoolean(message.ride);
        buf.func_179249_a((Enum)message.schedule);
    }

    public static MaidConfigMessage decode(PacketBuffer buf) {
        return new MaidConfigMessage(buf.readInt(), buf.readBoolean(), buf.readBoolean(), buf.readBoolean(), (MaidSchedule)buf.func_179257_a(MaidSchedule.class));
    }

    public static void handle(MaidConfigMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isServer()) {
            context.enqueueWork(() -> {
                ServerPlayerEntity sender = context.getSender();
                if (sender == null) {
                    return;
                }
                Entity entity = sender.field_70170_p.func_73045_a(message.id);
                if (entity instanceof EntityMaid && ((EntityMaid)entity).func_152114_e((LivingEntity)sender)) {
                    EntityMaid maid = (EntityMaid)entity;
                    if (maid.isHomeModeEnable() != message.home) {
                        MaidConfigMessage.handleHome(message, sender, maid);
                    }
                    if (maid.isPickup() != message.pick) {
                        maid.setPickup(message.pick);
                    }
                    if (maid.isRideable() != message.ride) {
                        maid.setRideable(message.ride);
                    }
                    if (maid.func_184187_bx() != null && !(maid.func_184187_bx() instanceof EntitySit)) {
                        maid.func_184210_p();
                    }
                    if (maid.getSchedule() != message.schedule) {
                        maid.setSchedule(message.schedule);
                        maid.getSchedulePos().restrictTo(maid);
                        if (maid.isHomeModeEnable()) {
                            BrainUtil.func_233866_a_((LivingEntity)maid, (BlockPos)maid.func_213384_dI(), (float)0.7f, (int)3);
                        }
                    }
                }
            });
        }
        context.setPacketHandled(true);
    }

    private static void handleHome(MaidConfigMessage message, ServerPlayerEntity sender, EntityMaid maid) {
        if (message.home) {
            ResourceLocation dimension = maid.getSchedulePos().getDimension();
            if (!dimension.equals((Object)maid.field_70170_p.func_234923_W_().func_240901_a_())) {
                CheckSchedulePosMessage tips = new CheckSchedulePosMessage((ITextComponent)new TranslationTextComponent("message.touhou_little_maid.check_schedule_pos.dimension"));
                NetworkHandler.sendToClientPlayer(tips, (PlayerEntity)sender);
                return;
            }
            BlockPos nearestPos = maid.getSchedulePos().getNearestPos(maid);
            if (nearestPos != null && nearestPos.func_177951_i((Vector3i)maid.func_233580_cy_()) > 1024.0) {
                CheckSchedulePosMessage tips = new CheckSchedulePosMessage((ITextComponent)new TranslationTextComponent("message.touhou_little_maid.check_schedule_pos.too_far"));
                NetworkHandler.sendToClientPlayer(tips, (PlayerEntity)sender);
                return;
            }
            maid.getSchedulePos().setHomeModeEnable(maid, maid.func_233580_cy_());
        } else {
            maid.func_213390_a(BlockPos.field_177992_a, (Integer)MaidConfig.MAID_NON_HOME_RANGE.get());
        }
        maid.setHomeModeEnable(message.home);
    }
}

