/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.network.NetworkEvent;

public class MaidModelMessage {
    private final int id;
    private final ResourceLocation modelId;

    public MaidModelMessage(int id, ResourceLocation modelId) {
        this.id = id;
        this.modelId = modelId;
    }

    public static void encode(MaidModelMessage message, PacketBuffer buf) {
        buf.writeInt(message.id);
        buf.func_192572_a(message.modelId);
    }

    public static MaidModelMessage decode(PacketBuffer buf) {
        return new MaidModelMessage(buf.readInt(), buf.func_192575_l());
    }

    public static void handle(MaidModelMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isServer()) {
            context.enqueueWork(() -> {
                ServerPlayerEntity sender = context.getSender();
                if (sender == null) {
                    return;
                }
                Entity entity = sender.field_70170_p.func_73045_a(message.id);
                if (entity instanceof EntityMaid && ((EntityMaid)entity).func_152114_e((LivingEntity)sender)) {
                    if (sender.func_184812_l_() || ((Boolean)MaidConfig.MAID_CHANGE_MODEL.get()).booleanValue()) {
                        ((EntityMaid)entity).setModelId(message.modelId.toString());
                    } else {
                        sender.func_241151_a_((ITextComponent)new TranslationTextComponent("message.touhou_little_maid.change_model.disabled"), ChatType.GAME_INFO, Util.field_240973_b_);
                    }
                }
            });
        }
        context.setPacketHandled(true);
    }
}

