/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.task.TaskManager;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;

public class MaidTaskMessage {
    private final int id;
    private final ResourceLocation uid;

    public MaidTaskMessage(int id, ResourceLocation uid) {
        this.id = id;
        this.uid = uid;
    }

    public static void encode(MaidTaskMessage message, PacketBuffer buf) {
        buf.writeInt(message.id);
        buf.func_192572_a(message.uid);
    }

    public static MaidTaskMessage decode(PacketBuffer buf) {
        return new MaidTaskMessage(buf.readInt(), buf.func_192575_l());
    }

    public static void handle(MaidTaskMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isServer()) {
            context.enqueueWork(() -> {
                ServerPlayerEntity sender = context.getSender();
                if (sender == null) {
                    return;
                }
                Entity entity = sender.field_70170_p.func_73045_a(message.id);
                if (entity instanceof EntityMaid && ((EntityMaid)entity).func_152114_e((LivingEntity)sender)) {
                    ((EntityMaid)entity).setTask(TaskManager.findTask(message.uid).orElse(TaskManager.getIdleTask()));
                }
            });
        }
        context.setPacketHandled(true);
    }
}

