/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.client.sound.data.MaidSoundInstance;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class PlayMaidSoundMessage {
    private final ResourceLocation soundEvent;
    private final String id;
    private final int entityId;

    public PlayMaidSoundMessage(ResourceLocation soundEvent, String id, int entityId) {
        this.soundEvent = soundEvent;
        this.id = id;
        this.entityId = entityId;
    }

    public static void encode(PlayMaidSoundMessage message, PacketBuffer buf) {
        buf.func_192572_a(message.soundEvent);
        buf.func_180714_a(message.id);
        buf.func_150787_b(message.entityId);
    }

    public static PlayMaidSoundMessage decode(PacketBuffer buf) {
        return new PlayMaidSoundMessage(buf.func_192575_l(), buf.func_218666_n(), buf.func_150792_a());
    }

    public static void handle(PlayMaidSoundMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isClient()) {
            context.enqueueWork(() -> PlayMaidSoundMessage.playSound(message));
        }
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void playSound(PlayMaidSoundMessage message) {
        Entity entity;
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e != null && (entity = mc.field_71441_e.func_73045_a(message.entityId)) instanceof EntityMaid) {
            EntityMaid maid = (EntityMaid)entity;
            SoundEvent event = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(message.soundEvent);
            if (event != null) {
                mc.func_147118_V().func_147682_a((ISound)new MaidSoundInstance(event, message.id, maid));
            }
        }
    }
}

