/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityModelSwitcher;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class SaveSwitcherDataMessage {
    private final BlockPos pos;
    private final List<TileEntityModelSwitcher.ModeInfo> modeInfos;

    public SaveSwitcherDataMessage(BlockPos pos, List<TileEntityModelSwitcher.ModeInfo> modeInfos) {
        this.pos = pos;
        this.modeInfos = modeInfos;
    }

    public static void encode(SaveSwitcherDataMessage message, PacketBuffer buf) {
        buf.func_179255_a(message.pos);
        buf.func_150787_b(message.modeInfos.size());
        for (TileEntityModelSwitcher.ModeInfo info : message.modeInfos) {
            info.toBuf(buf);
        }
    }

    public static SaveSwitcherDataMessage decode(PacketBuffer buf) {
        BlockPos pos = buf.func_179259_c();
        int size = buf.func_150792_a();
        ArrayList modeInfos = Lists.newArrayList();
        for (int i = 0; i < size; ++i) {
            modeInfos.add(TileEntityModelSwitcher.ModeInfo.fromBuf(buf));
        }
        return new SaveSwitcherDataMessage(pos, modeInfos);
    }

    public static void handle(SaveSwitcherDataMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isServer()) {
            context.enqueueWork(() -> {
                TileEntity te;
                ServerPlayerEntity sender = context.getSender();
                if (sender == null) {
                    return;
                }
                World world = sender.field_70170_p;
                if (world.func_195588_v(message.pos) && (te = world.func_175625_s(message.pos)) instanceof TileEntityModelSwitcher) {
                    ((TileEntityModelSwitcher)te).setInfoList(message.modeInfos);
                }
            });
        }
        context.setPacketHandled(true);
    }
}

