/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.EffectInstance;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkEvent;

public class SendEffectMessage {
    private final int id;
    private List<EffectData> effects = Lists.newArrayList();

    public SendEffectMessage(int id, Collection<EffectInstance> effects) {
        this.id = id;
        for (EffectInstance effect : effects) {
            this.effects.add(new EffectData(effect));
        }
    }

    public SendEffectMessage(int id, List<EffectData> effects) {
        this.id = id;
        this.effects = effects;
    }

    public static void encode(SendEffectMessage message, PacketBuffer buf) {
        buf.writeInt(message.id);
        buf.writeInt(message.effects.size());
        for (EffectData effect : message.effects) {
            effect.toBytes(buf);
        }
    }

    public static SendEffectMessage decode(PacketBuffer buf) {
        int id = buf.readInt();
        int size = buf.readInt();
        ArrayList effects = Lists.newArrayList();
        for (int i = 0; i < size; ++i) {
            effects.add(EffectData.fromBytes(buf));
        }
        return new SendEffectMessage(id, effects);
    }

    public static void handle(SendEffectMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isClient()) {
            context.enqueueWork(() -> SendEffectMessage.handle(message));
        }
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handle(SendEffectMessage message) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e == null) {
            return;
        }
        Entity entity = mc.field_71441_e.func_73045_a(message.id);
        if (entity instanceof EntityMaid && entity.func_70089_S()) {
            EntityMaid maid = (EntityMaid)entity;
            maid.setEffects(message.effects);
        }
    }

    public static class EffectData {
        public String descriptionId;
        public int amplifier;
        public int duration;
        public int category;

        public EffectData(EffectInstance effect) {
            this.descriptionId = effect.func_76453_d();
            this.amplifier = effect.func_76458_c();
            this.duration = effect.func_76459_b();
            this.category = effect.func_188419_a().func_220303_e().ordinal();
        }

        public EffectData(String descriptionId, int amplifier, int duration, int category) {
            this.descriptionId = descriptionId;
            this.amplifier = amplifier;
            this.duration = duration;
            this.category = category;
        }

        public static EffectData fromBytes(PacketBuffer buf) {
            return new EffectData(buf.func_218666_n(), buf.readInt(), buf.readInt(), buf.readInt());
        }

        public void toBytes(PacketBuffer buf) {
            buf.func_180714_a(this.descriptionId);
            buf.writeInt(this.amplifier);
            buf.writeInt(this.duration);
            buf.writeInt(this.category);
        }
    }
}

