/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Items;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.network.NetworkEvent;

public class SendNameTagMessage {
    private static final int MAX_STRING_LENGTH = 1024;
    private final int id;
    private final String name;
    private final boolean alwaysShow;

    public SendNameTagMessage(int id, String name, boolean alwaysShow) {
        this.id = id;
        this.name = name;
        this.alwaysShow = alwaysShow;
    }

    public static void encode(SendNameTagMessage message, PacketBuffer buf) {
        buf.writeInt(message.id);
        buf.func_211400_a(message.name, 1024);
        buf.writeBoolean(message.alwaysShow);
    }

    public static SendNameTagMessage decode(PacketBuffer buf) {
        return new SendNameTagMessage(buf.readInt(), buf.func_150789_c(1024), buf.readBoolean());
    }

    public static void handle(SendNameTagMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isServer()) {
            context.enqueueWork(() -> {
                ServerPlayerEntity sender = context.getSender();
                if (sender == null) {
                    return;
                }
                Entity entity = sender.field_70170_p.func_73045_a(message.id);
                if (entity instanceof EntityMaid) {
                    SendNameTagMessage.setMaidNameTag(message, sender, (EntityMaid)entity);
                }
            });
        }
        context.setPacketHandled(true);
    }

    private static void setMaidNameTag(SendNameTagMessage message, ServerPlayerEntity player, EntityMaid maid) {
        String name = message.name.substring(0, Math.min(32, message.name.length()));
        if (player.equals((Object)maid.func_70902_q()) && player.func_184614_ca().func_77973_b() == Items.field_151057_cb) {
            maid.func_200203_b((ITextComponent)new StringTextComponent(name));
            maid.func_174805_g(message.alwaysShow);
            maid.func_110163_bv();
            if (!player.func_184812_l_()) {
                player.func_184614_ca().func_190918_g(1);
            }
        }
    }
}

