/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityMaidBeacon;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class SetBeaconPotionMessage {
    private final BlockPos pos;
    private final int potionIndex;

    public SetBeaconPotionMessage(BlockPos pos, int potionIndex) {
        this.pos = pos;
        this.potionIndex = potionIndex;
    }

    public static void encode(SetBeaconPotionMessage message, PacketBuffer buf) {
        buf.func_179255_a(message.pos);
        buf.writeInt(message.potionIndex);
    }

    public static SetBeaconPotionMessage decode(PacketBuffer buf) {
        return new SetBeaconPotionMessage(buf.func_179259_c(), buf.readInt());
    }

    public static void handle(SetBeaconPotionMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isServer()) {
            context.enqueueWork(() -> {
                TileEntity te;
                ServerPlayerEntity sender = context.getSender();
                if (sender == null) {
                    return;
                }
                World world = sender.field_70170_p;
                if (world.func_195588_v(message.pos) && (te = world.func_175625_s(message.pos)) instanceof TileEntityMaidBeacon) {
                    ((TileEntityMaidBeacon)te).setPotionIndex(message.potionIndex);
                }
            });
        }
        context.setPacketHandled(true);
    }
}

