/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class SetMaidSoundIdMessage {
    private final int entityId;
    private final String soundId;

    public SetMaidSoundIdMessage(int entityId, String soundId) {
        this.entityId = entityId;
        this.soundId = soundId;
    }

    public static void encode(SetMaidSoundIdMessage message, PacketBuffer buf) {
        buf.writeInt(message.entityId);
        buf.func_180714_a(message.soundId);
    }

    public static SetMaidSoundIdMessage decode(PacketBuffer buf) {
        return new SetMaidSoundIdMessage(buf.readInt(), buf.func_218666_n());
    }

    public static void handle(SetMaidSoundIdMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isServer()) {
            context.enqueueWork(() -> {
                ServerPlayerEntity sender = context.getSender();
                if (sender == null) {
                    return;
                }
                Entity entity = sender.field_70170_p.func_73045_a(message.entityId);
                if (entity instanceof EntityMaid && ((EntityMaid)entity).func_152114_e((LivingEntity)sender)) {
                    EntityMaid maid = (EntityMaid)entity;
                    maid.setSoundPackId(message.soundId);
                }
            });
        }
        context.setPacketHandled(true);
    }
}

