/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.item.ItemFoxScroll;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class SetScrollData {
    private final String dimension;
    private final BlockPos pos;

    public SetScrollData(String dimension, BlockPos pos) {
        this.dimension = dimension;
        this.pos = pos;
    }

    public static void encode(SetScrollData message, PacketBuffer buf) {
        buf.func_180714_a(message.dimension);
        buf.func_179255_a(message.pos);
    }

    public static SetScrollData decode(PacketBuffer buf) {
        return new SetScrollData(buf.func_218666_n(), buf.func_179259_c());
    }

    public static void handle(SetScrollData message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isServer()) {
            context.enqueueWork(() -> {
                ServerPlayerEntity sender = context.getSender();
                if (sender == null) {
                    return;
                }
                ItemStack item = sender.func_184614_ca();
                if (item.func_77973_b() instanceof ItemFoxScroll) {
                    ItemFoxScroll.setTrackInfo(item, message.dimension, message.pos);
                }
            });
        }
        context.setPacketHandled(true);
    }
}

