/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkEvent;

public class SpawnParticleMessage {
    private final int entityId;
    private final Type particleType;

    public SpawnParticleMessage(int entityId, Type particleType) {
        this.entityId = entityId;
        this.particleType = particleType;
    }

    public static void encode(SpawnParticleMessage message, PacketBuffer buf) {
        buf.writeInt(message.entityId);
        buf.writeInt(message.particleType.ordinal());
    }

    public static SpawnParticleMessage decode(PacketBuffer buf) {
        return new SpawnParticleMessage(buf.readInt(), SpawnParticleMessage.getTypeByIndex(buf.readInt()));
    }

    public static void handle(SpawnParticleMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isClient()) {
            context.enqueueWork(() -> SpawnParticleMessage.handleSpawnParticle(message));
        }
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleSpawnParticle(SpawnParticleMessage message) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e == null) {
            return;
        }
        Entity e = mc.field_71441_e.func_73045_a(message.entityId);
        if (e instanceof EntityMaid && e.func_70089_S()) {
            EntityMaid maid = (EntityMaid)e;
            switch (message.particleType) {
                case EXPLOSION: {
                    maid.spawnExplosionParticle();
                    return;
                }
                case BUBBLE: {
                    maid.spawnBubbleParticle();
                    return;
                }
                case HEART: {
                    maid.spawnHeartParticle();
                    return;
                }
                case RANK_UP: {
                    maid.spawnRankUpParticle();
                    return;
                }
            }
        }
    }

    private static Type getTypeByIndex(int index) {
        return Type.values()[MathHelper.func_76125_a((int)index, (int)0, (int)(Type.values().length - 1))];
    }

    public static enum Type {
        EXPLOSION,
        BUBBLE,
        HEART,
        RANK_UP;

    }
}

