/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.capability.PowerCapability;
import com.github.tartaricacid.touhoulittlemaid.capability.PowerCapabilityProvider;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityMaidBeacon;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class StorageAndTakePowerMessage {
    private final BlockPos pos;
    private final float powerNum;
    private final boolean isStorage;

    public StorageAndTakePowerMessage(BlockPos pos, float powerNum, boolean isStorage) {
        this.pos = pos;
        this.powerNum = powerNum;
        this.isStorage = isStorage;
    }

    public static void encode(StorageAndTakePowerMessage message, PacketBuffer buf) {
        buf.func_179255_a(message.pos);
        buf.writeFloat(message.powerNum);
        buf.writeBoolean(message.isStorage);
    }

    public static StorageAndTakePowerMessage decode(PacketBuffer buf) {
        return new StorageAndTakePowerMessage(buf.func_179259_c(), buf.readFloat(), buf.readBoolean());
    }

    public static void handle(StorageAndTakePowerMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isServer()) {
            context.enqueueWork(() -> {
                TileEntity te;
                ServerPlayerEntity sender = context.getSender();
                if (sender == null) {
                    return;
                }
                World world = sender.field_70170_p;
                if (world.func_195588_v(message.pos) && (te = world.func_175625_s(message.pos)) instanceof TileEntityMaidBeacon) {
                    TileEntityMaidBeacon beacon = (TileEntityMaidBeacon)te;
                    sender.getCapability(PowerCapabilityProvider.POWER_CAP).ifPresent(power -> {
                        if (message.isStorage) {
                            StorageAndTakePowerMessage.storageLogic(message.powerNum, power, beacon);
                        } else {
                            StorageAndTakePowerMessage.takeLogic(message.powerNum, power, beacon);
                        }
                    });
                }
            });
        }
        context.setPacketHandled(true);
    }

    private static void storageLogic(float powerNum, PowerCapability playerPower, TileEntityMaidBeacon beacon) {
        boolean beaconNotFull;
        boolean playerPowerIsEnough = powerNum <= playerPower.get();
        boolean bl = beaconNotFull = powerNum + beacon.getStoragePower() <= beacon.getMaxStorage();
        if (playerPowerIsEnough) {
            if (beaconNotFull) {
                playerPower.min(powerNum);
                beacon.setStoragePower(beacon.getStoragePower() + powerNum);
            } else {
                playerPower.min(beacon.getMaxStorage() - beacon.getStoragePower());
                beacon.setStoragePower(beacon.getMaxStorage());
            }
        }
    }

    private static void takeLogic(float powerNum, PowerCapability playerPower, TileEntityMaidBeacon beacon) {
        boolean playerNotFull;
        boolean beaconIsEnough = powerNum <= beacon.getStoragePower();
        boolean bl = playerNotFull = powerNum + playerPower.get() < 5.0f;
        if (beaconIsEnough) {
            if (playerNotFull) {
                beacon.setStoragePower(beacon.getStoragePower() - powerNum);
                playerPower.add(powerNum);
            } else {
                beacon.setStoragePower(beacon.getStoragePower() - 5.0f + playerPower.get());
                playerPower.set(5.0f);
            }
        }
    }
}

