/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.capability.MaidNumCapabilityProvider;
import com.github.tartaricacid.touhoulittlemaid.capability.PowerCapabilityProvider;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkEvent;

public class SyncCapabilityMessage {
    private final float power;
    private final int maidNum;

    public SyncCapabilityMessage(float power, int maidNum) {
        this.power = power;
        this.maidNum = maidNum;
    }

    public static void encode(SyncCapabilityMessage message, PacketBuffer buf) {
        buf.writeFloat(message.power);
        buf.func_150787_b(message.maidNum);
    }

    public static SyncCapabilityMessage decode(PacketBuffer buf) {
        return new SyncCapabilityMessage(buf.readFloat(), buf.func_150792_a());
    }

    public static void handle(SyncCapabilityMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isClient()) {
            context.enqueueWork(() -> SyncCapabilityMessage.handleCapability(message));
        }
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleCapability(SyncCapabilityMessage message) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e == null || mc.field_71439_g == null) {
            return;
        }
        mc.field_71439_g.getCapability(PowerCapabilityProvider.POWER_CAP).ifPresent(cap -> cap.set(message.power));
        mc.field_71439_g.getCapability(MaidNumCapabilityProvider.MAID_NUM_CAP).ifPresent(cap -> cap.set(message.maidNum));
    }
}

