/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.client.event.MaidAreaRenderEvent;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.SchedulePos;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkEvent;

public class SyncMaidAreaMessage {
    private final int id;
    private final SchedulePos schedulePos;

    public SyncMaidAreaMessage(int id, SchedulePos schedulePos) {
        this.id = id;
        this.schedulePos = schedulePos;
    }

    public static void encode(SyncMaidAreaMessage message, PacketBuffer buf) {
        SchedulePos pos = message.schedulePos;
        buf.func_150787_b(message.id);
        buf.func_179255_a(pos.getWorkPos());
        buf.func_179255_a(pos.getIdlePos());
        buf.func_179255_a(pos.getSleepPos());
        buf.func_192572_a(pos.getDimension());
    }

    public static SyncMaidAreaMessage decode(PacketBuffer buf) {
        int maidId = buf.func_150792_a();
        BlockPos workPos = buf.func_179259_c();
        BlockPos idlePos = buf.func_179259_c();
        BlockPos sleepPos = buf.func_179259_c();
        ResourceLocation dimension = buf.func_192575_l();
        SchedulePos pos = new SchedulePos(workPos, idlePos, sleepPos, dimension);
        return new SyncMaidAreaMessage(maidId, pos);
    }

    public static void handle(SyncMaidAreaMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isClient()) {
            context.enqueueWork(() -> SyncMaidAreaMessage.writePos(message));
        }
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void writePos(SyncMaidAreaMessage message) {
        MaidAreaRenderEvent.addSchedulePos(message.id, message.schedulePos);
    }
}

