/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class ToggleTabMessage {
    private final int entityId;
    private final int tabId;

    public ToggleTabMessage(int entityId, int tabId) {
        this.entityId = entityId;
        this.tabId = tabId;
    }

    public static void encode(ToggleTabMessage message, PacketBuffer buf) {
        buf.writeInt(message.entityId);
        buf.writeInt(message.tabId);
    }

    public static ToggleTabMessage decode(PacketBuffer buf) {
        return new ToggleTabMessage(buf.readInt(), buf.readInt());
    }

    public static void handle(ToggleTabMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isServer()) {
            context.enqueueWork(() -> {
                ServerPlayerEntity sender = context.getSender();
                if (sender == null) {
                    return;
                }
                Entity entity = sender.field_70170_p.func_73045_a(message.entityId);
                if (entity instanceof EntityMaid && ((EntityMaid)entity).func_152114_e((LivingEntity)sender)) {
                    ((EntityMaid)entity).openMaidGui((PlayerEntity)sender, message.tabId);
                }
            });
        }
        context.setPacketHandled(true);
    }
}

