/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.item.ItemWirelessIO;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkHooks;

public class WirelessIOSlotConfigMessage {
    private static final byte[] EMPTY = new byte[0];
    private final byte[] configData;

    public WirelessIOSlotConfigMessage(byte[] configData) {
        this.configData = configData;
    }

    public WirelessIOSlotConfigMessage() {
        this(EMPTY);
    }

    public static void encode(WirelessIOSlotConfigMessage message, PacketBuffer buf) {
        buf.func_179250_a(message.configData);
    }

    public static WirelessIOSlotConfigMessage decode(PacketBuffer buf) {
        return new WirelessIOSlotConfigMessage(buf.func_179251_a());
    }

    public static void handle(WirelessIOSlotConfigMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isServer()) {
            context.enqueueWork(() -> {
                ServerPlayerEntity sender = context.getSender();
                if (sender == null) {
                    return;
                }
                ItemStack handItem = sender.func_184614_ca();
                if (handItem.func_77973_b() == InitItems.WIRELESS_IO.get()) {
                    if (message.configData.length > 0) {
                        ItemWirelessIO.setSlotConfig(handItem, message.configData);
                    }
                    NetworkHooks.openGui((ServerPlayerEntity)sender, (INamedContainerProvider)((ItemWirelessIO)handItem.func_77973_b()), buffer -> buffer.func_150788_a(handItem));
                }
            });
        }
        context.setPacketHandled(true);
    }
}

