/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.tileentity;

import com.github.tartaricacid.touhoulittlemaid.init.InitBlocks;
import com.github.tartaricacid.touhoulittlemaid.inventory.handler.AltarItemHandler;
import com.github.tartaricacid.touhoulittlemaid.util.PosListData;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityAltar
extends TileEntity {
    private static final String STORAGE_ITEM = "StorageItem";
    public static final TileEntityType<TileEntityAltar> TYPE = TileEntityType.Builder.func_223042_a(TileEntityAltar::new, (Block[])new Block[]{(Block)InitBlocks.ALTAR.get()}).func_206865_a(null);
    private static final String IS_RENDER = "IsRender";
    private static final String CAN_PLACE_ITEM = "CanPlaceItem";
    private static final String STORAGE_STATE_ID = "StorageBlockStateId";
    private static final String DIRECTION = "Direction";
    private static final String STORAGE_BLOCK_LIST = "StorageBlockList";
    private static final String CAN_PLACE_ITEM_POS_LIST = "CanPlaceItemPosList";
    public final ItemStackHandler handler = new AltarItemHandler();
    private boolean isRender = false;
    private boolean canPlaceItem = false;
    private BlockState storageState = Blocks.field_150350_a.func_176223_P();
    private PosListData blockPosList = new PosListData();
    private PosListData canPlaceItemPosList = new PosListData();
    private Direction direction = Direction.SOUTH;

    public TileEntityAltar() {
        super(TYPE);
    }

    public void setForgeData(BlockState storageState, boolean isRender, boolean canPlaceItem, Direction direction, PosListData blockPosList, PosListData canPlaceItemPosList) {
        this.isRender = isRender;
        this.canPlaceItem = canPlaceItem;
        this.storageState = storageState;
        this.direction = direction;
        this.blockPosList = blockPosList;
        this.canPlaceItemPosList = canPlaceItemPosList;
        this.refresh();
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        this.getTileData().func_74757_a(IS_RENDER, this.isRender);
        this.getTileData().func_74757_a(CAN_PLACE_ITEM, this.canPlaceItem);
        this.getTileData().func_74768_a(STORAGE_STATE_ID, Block.func_196246_j((BlockState)this.storageState));
        this.getTileData().func_218657_a(STORAGE_ITEM, (INBT)this.handler.serializeNBT());
        this.getTileData().func_74778_a(DIRECTION, this.direction.func_176610_l());
        this.getTileData().func_218657_a(STORAGE_BLOCK_LIST, (INBT)this.blockPosList.serialize());
        this.getTileData().func_218657_a(CAN_PLACE_ITEM_POS_LIST, (INBT)this.canPlaceItemPosList.serialize());
        return super.func_189515_b(compound);
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.isRender = this.getTileData().func_74767_n(IS_RENDER);
        this.canPlaceItem = this.getTileData().func_74767_n(CAN_PLACE_ITEM);
        this.storageState = Block.func_196257_b((int)this.getTileData().func_74762_e(STORAGE_STATE_ID));
        this.handler.deserializeNBT(this.getTileData().func_74775_l(STORAGE_ITEM));
        this.direction = Direction.func_176739_a((String)this.getTileData().func_74779_i(DIRECTION));
        this.blockPosList.deserialize(this.getTileData().func_150295_c(STORAGE_BLOCK_LIST, 10));
        this.canPlaceItemPosList.deserialize(this.getTileData().func_150295_c(CAN_PLACE_ITEM_POS_LIST, 10));
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c.func_177982_a(-9, -5, -9), this.field_174879_c.func_177982_a(9, 5, 9));
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), -1, this.func_189515_b(new CompoundNBT()));
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        if (this.field_145850_b != null) {
            this.func_230337_a_(this.field_145850_b.func_180495_p(pkt.func_179823_a()), pkt.func_148857_g());
        }
    }

    public void refresh() {
        this.func_70296_d();
        if (this.field_145850_b != null) {
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        }
    }

    public boolean isRender() {
        return this.isRender;
    }

    public boolean isCanPlaceItem() {
        return this.canPlaceItem;
    }

    public BlockState getStorageState() {
        return this.storageState;
    }

    public PosListData getBlockPosList() {
        return this.blockPosList;
    }

    public PosListData getCanPlaceItemPosList() {
        return this.canPlaceItemPosList;
    }

    public ItemStack getStorageItem() {
        if (this.canPlaceItem) {
            return this.handler.getStackInSlot(0);
        }
        return ItemStack.field_190927_a;
    }

    public Direction getDirection() {
        return this.direction;
    }
}

