/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.tileentity;

import com.github.tartaricacid.touhoulittlemaid.api.game.gomoku.Point;
import com.github.tartaricacid.touhoulittlemaid.init.InitBlocks;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityJoy;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntityType;

public class TileEntityGomoku
extends TileEntityJoy {
    public static final TileEntityType<TileEntityGomoku> TYPE = TileEntityType.Builder.func_223042_a(TileEntityGomoku::new, (Block[])new Block[]{(Block)InitBlocks.GOMOKU.get()}).func_206865_a(null);
    private static final String CHESS_DATA = "ChessData";
    private static final String IN_PROGRESS = "InProgress";
    private static final String PLAYER_TURN = "PlayerTurn";
    private static final String CHESS_COUNTER = "ChessCounter";
    private static final String LATEST_CHESS_POINT = "LatestChessPoint";
    private int[][] chessData = new int[15][15];
    private boolean inProgress = true;
    private boolean playerTurn = true;
    private int chessCounter = 0;
    private Point latestChessPoint = Point.NULL;

    public TileEntityGomoku() {
        super(TYPE);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        ListNBT listTag = new ListNBT();
        for (int[] chessRow : this.chessData) {
            listTag.add((Object)new IntArrayNBT(chessRow));
        }
        this.getTileData().func_218657_a(CHESS_DATA, (INBT)listTag);
        this.getTileData().func_74757_a(IN_PROGRESS, this.inProgress);
        this.getTileData().func_74757_a(PLAYER_TURN, this.playerTurn);
        this.getTileData().func_74768_a(CHESS_COUNTER, this.chessCounter);
        this.getTileData().func_218657_a(LATEST_CHESS_POINT, (INBT)Point.toTag(this.latestChessPoint));
        return super.func_189515_b(tag);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        ListNBT listTag = this.getTileData().func_150295_c(CHESS_DATA, 11);
        for (int i = 0; i < listTag.size(); ++i) {
            int[] intArray = listTag.func_150306_c(i);
            this.chessData[i] = intArray;
        }
        this.inProgress = this.getTileData().func_74767_n(IN_PROGRESS);
        this.playerTurn = this.getTileData().func_74767_n(PLAYER_TURN);
        this.chessCounter = this.getTileData().func_74762_e(CHESS_COUNTER);
        this.latestChessPoint = Point.fromTag(this.getTileData().func_74775_l(LATEST_CHESS_POINT));
    }

    public void reset() {
        this.chessData = new int[15][15];
        this.inProgress = true;
        this.playerTurn = true;
        this.chessCounter = 0;
        this.latestChessPoint = Point.NULL;
    }

    public int[][] getChessData() {
        return this.chessData;
    }

    public void setChessData(int x, int y, int type) {
        this.chessData[x][y] = type;
        this.latestChessPoint = new Point(x, y, type);
        ++this.chessCounter;
    }

    public boolean isPlayerTurn() {
        return this.playerTurn;
    }

    public void setPlayerTurn(boolean playerTurn) {
        this.playerTurn = playerTurn;
    }

    public boolean isInProgress() {
        return this.inProgress;
    }

    public void setInProgress(boolean inProgress) {
        this.inProgress = inProgress;
    }

    public int getChessCounter() {
        return this.chessCounter;
    }

    public Point getLatestChessPoint() {
        return this.latestChessPoint;
    }
}

