/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.tileentity;

import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MiscConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityPowerPoint;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitBlocks;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class TileEntityMaidBeacon
extends TileEntity
implements ITickableTileEntity {
    public static final String POTION_INDEX_TAG = "PotionIndex";
    public static final TileEntityType<TileEntityMaidBeacon> TYPE = TileEntityType.Builder.func_223042_a(TileEntityMaidBeacon::new, (Block[])new Block[]{(Block)InitBlocks.MAID_BEACON.get()}).func_206865_a(null);
    public static final String STORAGE_POWER_TAG = "StoragePower";
    public static final String OVERFLOW_DELETE_TAG = "OverflowDelete";
    private int potionIndex = -1;
    private float storagePower;
    private boolean overflowDelete = false;

    public TileEntityMaidBeacon() {
        super(TYPE);
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 80L == 0L) {
            if (this.potionIndex != -1 && this.storagePower >= this.getEffectCost()) {
                this.storagePower -= this.getEffectCost();
                this.updateBeaconEffect(this.field_145850_b, BeaconEffect.getEffectByIndex(this.potionIndex).getEffect());
            }
            this.updateAbsorbPower(this.field_145850_b);
        }
    }

    private void updateBeaconEffect(World world, Effect potion) {
        List list = world.func_175647_a(EntityMaid.class, new AxisAlignedBB(this.func_174877_v()).func_72314_b(8.0, 8.0, 8.0), LivingEntity::func_70089_S);
        for (EntityMaid maid : list) {
            maid.func_195064_c(new EffectInstance(potion, 100, 1, true, true));
        }
    }

    private void updateAbsorbPower(World world) {
        int range = (Integer)MiscConfig.SHRINE_LAMP_MAX_RANGE.get();
        List list = world.func_175647_a(EntityPowerPoint.class, new AxisAlignedBB(this.func_174877_v()).func_72314_b((double)range, (double)range, (double)range), Entity::func_70089_S);
        for (EntityPowerPoint powerPoint : list) {
            float addNum = this.getStoragePower() + (float)powerPoint.value / 100.0f;
            if (addNum <= this.getMaxStorage()) {
                this.setStoragePower(addNum);
                powerPoint.spawnExplosionParticle();
                powerPoint.func_70106_y();
                continue;
            }
            if (!this.overflowDelete) continue;
            powerPoint.spawnExplosionParticle();
            powerPoint.func_70106_y();
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        this.getTileData().func_74768_a(POTION_INDEX_TAG, this.potionIndex);
        this.getTileData().func_74776_a(STORAGE_POWER_TAG, this.storagePower);
        this.getTileData().func_74757_a(OVERFLOW_DELETE_TAG, this.overflowDelete);
        return super.func_189515_b(compound);
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.potionIndex = this.getTileData().func_74762_e(POTION_INDEX_TAG);
        this.storagePower = this.getTileData().func_74760_g(STORAGE_POWER_TAG);
        this.overflowDelete = this.getTileData().func_74767_n(OVERFLOW_DELETE_TAG);
    }

    public void loadData(CompoundNBT data) {
        this.potionIndex = data.func_74762_e(POTION_INDEX_TAG);
        this.storagePower = data.func_74760_g(STORAGE_POWER_TAG);
        this.overflowDelete = data.func_74767_n(OVERFLOW_DELETE_TAG);
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), -1, this.func_189515_b(new CompoundNBT()));
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        if (this.field_145850_b != null) {
            this.func_230337_a_(this.field_145850_b.func_180495_p(pkt.func_179823_a()), pkt.func_148857_g());
        }
    }

    public int getPotionIndex() {
        return this.potionIndex;
    }

    public void setPotionIndex(int potionIndex) {
        this.potionIndex = potionIndex;
        this.refresh();
    }

    public float getStoragePower() {
        return this.storagePower;
    }

    public void setStoragePower(float storagePower) {
        this.storagePower = storagePower;
        this.refresh();
    }

    public boolean isOverflowDelete() {
        return this.overflowDelete;
    }

    public void setOverflowDelete(boolean overflowDelete) {
        this.overflowDelete = overflowDelete;
        this.refresh();
    }

    public float getEffectCost() {
        return (float)((Double)MiscConfig.SHRINE_LAMP_EFFECT_COST.get() / 900.0);
    }

    public float getMaxStorage() {
        return ((Double)MiscConfig.SHRINE_LAMP_MAX_STORAGE.get()).floatValue();
    }

    public void refresh() {
        this.func_70296_d();
        if (this.field_145850_b != null) {
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        }
    }

    public static enum BeaconEffect {
        SPEED(Effects.field_76424_c),
        FIRE_RESISTANCE(Effects.field_76426_n),
        STRENGTH(Effects.field_76420_g),
        RESISTANCE(Effects.field_76429_m),
        REGENERATION(Effects.field_76428_l);

        private final Effect effect;

        private BeaconEffect(Effect effect) {
            this.effect = effect;
        }

        public static BeaconEffect getEffectByIndex(int index) {
            return BeaconEffect.values()[MathHelper.func_76125_a((int)0, (int)index, (int)(BeaconEffect.values().length - 1))];
        }

        public Effect getEffect() {
            return this.effect;
        }
    }
}

