/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.tileentity;

import com.github.tartaricacid.touhoulittlemaid.init.InitBlocks;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;

public class TileEntityModelSwitcher
extends TileEntity {
    public static final String INFO_LIST = "info_list";
    public static final String ENTITY_UUID = "entity_uuid";
    public static final TileEntityType<TileEntityModelSwitcher> TYPE = TileEntityType.Builder.func_223042_a(TileEntityModelSwitcher::new, (Block[])new Block[]{(Block)InitBlocks.MODEL_SWITCHER.get()}).func_206865_a(null);
    public static final String LIST_INDEX = "list_index";
    private List<ModeInfo> infoList = Lists.newArrayList();
    private boolean isPowered;
    private UUID uuid;
    private int index;

    public TileEntityModelSwitcher() {
        super(TYPE);
    }

    public CompoundNBT func_189515_b(CompoundNBT pTag) {
        ListNBT listTag = new ListNBT();
        for (ModeInfo info : this.infoList) {
            listTag.add((Object)info.serialize());
        }
        this.getTileData().func_218657_a(INFO_LIST, (INBT)listTag);
        if (this.uuid != null) {
            this.getTileData().func_218657_a(ENTITY_UUID, (INBT)NBTUtil.func_240626_a_((UUID)this.uuid));
        }
        this.getTileData().func_74768_a(LIST_INDEX, this.index);
        return super.func_189515_b(pTag);
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.infoList.clear();
        ListNBT listTag = this.getTileData().func_150295_c(INFO_LIST, 10);
        for (int i = 0; i < listTag.size(); ++i) {
            ModeInfo info = new ModeInfo();
            info.deserialize(listTag.func_150305_b(i));
            this.infoList.add(info);
        }
        INBT uuidTag = this.getTileData().func_74781_a(ENTITY_UUID);
        if (uuidTag != null) {
            this.uuid = NBTUtil.func_186860_b((INBT)uuidTag);
        }
        this.index = this.getTileData().func_74762_e(LIST_INDEX);
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), -1, this.func_189515_b(new CompoundNBT()));
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        if (this.field_145850_b != null) {
            this.func_230337_a_(this.field_145850_b.func_180495_p(pkt.func_179823_a()), pkt.func_148857_g());
        }
    }

    @Nullable
    public UUID getUuid() {
        return this.uuid;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
        this.refresh();
    }

    public boolean isPowered() {
        return this.isPowered;
    }

    public void setPowered(boolean powered) {
        this.isPowered = powered;
    }

    @Nullable
    public ModeInfo getModelInfo() {
        if (0 <= this.index && this.index < this.infoList.size()) {
            return this.infoList.get(this.index);
        }
        return null;
    }

    public List<ModeInfo> getInfoList() {
        return this.infoList;
    }

    public void setInfoList(List<ModeInfo> infoList) {
        this.infoList = infoList;
        this.refresh();
    }

    public void refresh() {
        this.func_70296_d();
        if (this.field_145850_b != null) {
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        }
    }

    public static class ModeInfo {
        private ResourceLocation modelId;
        private String text;
        private Direction direction;

        public ModeInfo() {
        }

        public ModeInfo(ResourceLocation modelId, String text, Direction direction) {
            this.modelId = modelId;
            this.text = text;
            this.direction = direction;
        }

        public static ModeInfo fromBuf(PacketBuffer buf) {
            return new ModeInfo(buf.func_192575_l(), buf.func_218666_n(), Direction.func_176731_b((int)buf.func_150792_a()));
        }

        public ResourceLocation getModelId() {
            return this.modelId;
        }

        public void setModelId(ResourceLocation modelId) {
            this.modelId = modelId;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public Direction getDirection() {
            return this.direction;
        }

        public void setDirection(Direction direction) {
            this.direction = direction;
        }

        public void toBuf(PacketBuffer buf) {
            buf.func_192572_a(this.modelId);
            buf.func_180714_a(this.text);
            buf.func_150787_b(this.direction.func_176736_b());
        }

        public CompoundNBT serialize() {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74778_a("model_id", this.modelId.toString());
            tag.func_74778_a("text", this.text);
            tag.func_74768_a("direction", this.direction.func_176736_b());
            return tag;
        }

        public void deserialize(CompoundNBT nbt) {
            this.modelId = new ResourceLocation(nbt.func_74779_i("model_id"));
            this.text = nbt.func_74779_i("text");
            this.direction = Direction.func_176731_b((int)nbt.func_74762_e("direction"));
        }
    }
}

