/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.tileentity;

import com.github.tartaricacid.touhoulittlemaid.init.InitBlocks;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TileEntityStatue
extends TileEntity {
    private static final String STATUE_SIZE_TAG = "StatueSize";
    public static final TileEntityType<TileEntityStatue> TYPE = TileEntityType.Builder.func_223042_a(TileEntityStatue::new, (Block[])new Block[]{(Block)InitBlocks.STATUE.get()}).func_206865_a(null);
    private static final String CORE_BLOCK_TAG = "CoreBlock";
    private static final String CORE_BLOCK_POS_TAG = "CoreBlockPos";
    private static final String STATUE_FACING_TAG = "StatueFacing";
    private static final String ALL_BLOCKS_TAG = "AllBlocks";
    private static final String EXTRA_MAID_DATA = "ExtraMaidData";
    private Size size = Size.SMALL;
    private boolean isCoreBlock = false;
    private BlockPos coreBlockPos = BlockPos.field_177992_a;
    private Direction facing = Direction.NORTH;
    private List<BlockPos> allBlocks = Lists.newArrayList();
    @Nullable
    private CompoundNBT extraMaidData = null;

    public TileEntityStatue() {
        super(TYPE);
    }

    public void setForgeData(Size size, boolean isCoreBlock, BlockPos coreBlockPos, Direction facing, List<BlockPos> allBlocks, @Nullable CompoundNBT extraData) {
        this.size = size;
        this.isCoreBlock = isCoreBlock;
        this.coreBlockPos = coreBlockPos;
        this.facing = facing;
        this.allBlocks = allBlocks;
        this.extraMaidData = extraData;
        this.refresh();
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        this.getTileData().func_74768_a(STATUE_SIZE_TAG, this.size.ordinal());
        this.getTileData().func_74757_a(CORE_BLOCK_TAG, this.isCoreBlock);
        this.getTileData().func_218657_a(CORE_BLOCK_POS_TAG, (INBT)NBTUtil.func_186859_a((BlockPos)this.coreBlockPos));
        this.getTileData().func_74778_a(STATUE_FACING_TAG, this.facing.func_176610_l());
        ListNBT blockList = new ListNBT();
        for (BlockPos pos : this.allBlocks) {
            blockList.add((Object)NBTUtil.func_186859_a((BlockPos)pos));
        }
        this.getTileData().func_218657_a(ALL_BLOCKS_TAG, (INBT)blockList);
        if (this.extraMaidData != null) {
            this.getTileData().func_218657_a(EXTRA_MAID_DATA, (INBT)this.extraMaidData);
        }
        return super.func_189515_b(compound);
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.size = Size.getSizeByIndex(this.getTileData().func_74762_e(STATUE_SIZE_TAG));
        this.isCoreBlock = this.getTileData().func_74767_n(CORE_BLOCK_TAG);
        this.coreBlockPos = NBTUtil.func_186861_c((CompoundNBT)this.getTileData().func_74775_l(CORE_BLOCK_POS_TAG));
        this.facing = Direction.func_176739_a((String)this.getTileData().func_74779_i(STATUE_FACING_TAG));
        this.allBlocks.clear();
        ListNBT blockList = this.getTileData().func_150295_c(ALL_BLOCKS_TAG, 10);
        for (int i = 0; i < blockList.size(); ++i) {
            this.allBlocks.add(NBTUtil.func_186861_c((CompoundNBT)blockList.func_150305_b(i)));
        }
        if (this.getTileData().func_150297_b(EXTRA_MAID_DATA, 10)) {
            this.extraMaidData = this.getTileData().func_74775_l(EXTRA_MAID_DATA);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c.func_177982_a(-5, -1, -5), this.field_174879_c.func_177982_a(5, 10, 5));
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), -1, this.func_189515_b(new CompoundNBT()));
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        if (this.field_145850_b != null) {
            this.func_230337_a_(this.field_145850_b.func_180495_p(pkt.func_179823_a()), pkt.func_148857_g());
        }
    }

    public void refresh() {
        this.func_70296_d();
        if (this.field_145850_b != null) {
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        }
    }

    public Size getSize() {
        return this.size;
    }

    public boolean isCoreBlock() {
        return this.isCoreBlock;
    }

    public BlockPos getCoreBlockPos() {
        return this.coreBlockPos;
    }

    public Direction getFacing() {
        return this.facing;
    }

    public List<BlockPos> getAllBlocks() {
        return this.allBlocks;
    }

    @Nullable
    public CompoundNBT getExtraMaidData() {
        return this.extraMaidData;
    }

    public static enum Size {
        TINY(0.5f, new Vector3i(1, 1, 1)),
        SMALL(1.0f, new Vector3i(1, 2, 1)),
        MIDDLE(2.0f, new Vector3i(2, 4, 2)),
        BIG(3.0f, new Vector3i(3, 6, 3));

        private final float scale;
        private final Vector3i dimension;

        private Size(float scale, Vector3i dimension) {
            this.scale = scale;
            this.dimension = dimension;
        }

        public static Size getSizeByIndex(int index) {
            return Size.values()[MathHelper.func_76125_a((int)index, (int)0, (int)(Size.values().length - 1))];
        }

        public float getScale() {
            return this.scale;
        }

        public Vector3i getDimension() {
            return this.dimension;
        }
    }
}

