/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.util;

import org.apache.commons.lang3.StringUtils;

public final class DataUtils {
    public static boolean isValidResourceLocation(String name) {
        String[] strings = DataUtils.decompose(name, ':');
        return DataUtils.isValidNamespace(StringUtils.isEmpty((CharSequence)strings[0]) ? "minecraft" : strings[0]) && DataUtils.isValidPath(strings[1]);
    }

    public static String[] decompose(String name, char split) {
        String[] strings = new String[]{"minecraft", name};
        int index = name.indexOf(split);
        if (index >= 0) {
            strings[1] = name.substring(index + 1);
            if (index >= 1) {
                strings[0] = name.substring(0, index);
            }
        }
        return strings;
    }

    public static boolean validPathChar(char charValue) {
        return charValue == '_' || charValue == '-' || charValue >= 'a' && charValue <= 'z' || charValue >= '0' && charValue <= '9' || charValue == '/' || charValue == '.';
    }

    private static boolean validNamespaceChar(char charValue) {
        return charValue == '_' || charValue == '-' || charValue >= 'a' && charValue <= 'z' || charValue >= '0' && charValue <= '9' || charValue == '.';
    }

    public static boolean isValidPath(String path) {
        for (int i = 0; i < path.length(); ++i) {
            if (DataUtils.validPathChar(path.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidNamespace(String name) {
        for (int i = 0; i < name.length(); ++i) {
            if (DataUtils.validNamespaceChar(name.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

