/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.util;

import com.github.tartaricacid.touhoulittlemaid.entity.backpack.BackpackManager;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="touhou_little_maid", value={Dist.CLIENT})
public final class EntityCacheUtil {
    public static final Cache<EntityType<?>, Entity> ENTITY_CACHE = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build();
    private static RegistryKey<World> dimAt;

    public static void clearMaidDataResidue(EntityMaid maid, boolean clearEquipmentData) {
        maid.field_70738_aO = 0;
        maid.field_70737_aN = 0;
        maid.field_70725_aQ = 0;
        maid.func_230245_c_(true);
        maid.func_233686_v_(false);
        maid.setMaidBackpackType(BackpackManager.getEmptyBackpack());
        maid.func_200203_b(StringTextComponent.field_240750_d_);
        if (clearEquipmentData) {
            for (EquipmentSlotType slot : EquipmentSlotType.values()) {
                maid.func_184201_a(slot, ItemStack.field_190927_a);
            }
        }
    }

    @SubscribeEvent
    public static void onChangeDim(EntityJoinWorldEvent event) {
        RegistryKey dim;
        if (event.getWorld().field_72995_K && event.getEntity() == Minecraft.func_71410_x().field_71439_g && !(dim = event.getEntity().field_70170_p.func_234923_W_()).equals(dimAt)) {
            dimAt = dim;
            ENTITY_CACHE.invalidateAll();
        }
    }
}

