/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.util.JSONUtils;
import org.apache.commons.lang3.StringUtils;

public final class EntityCraftingHelper {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final String TYPE_TAG = "type";
    private static final String NBT_TAG = "nbt";
    private static final String COPY_TAG = "copy";
    private static final String INGREDIENT_TAG = "ingredient";
    private static final String TAG_TAG = "tag";

    public static Output getEntityData(JsonObject json) {
        try {
            Optional optional = EntityType.func_220327_a((String)JSONUtils.func_151200_h((JsonObject)json, (String)TYPE_TAG));
            if (optional.isPresent()) {
                JsonElement copyElement;
                EntityType type = (EntityType)optional.get();
                JsonElement nbtElement = json.get(NBT_TAG);
                CompoundNBT outputData = new CompoundNBT();
                if (nbtElement != null) {
                    outputData = nbtElement.isJsonObject() ? JsonToNBT.func_180713_a((String)GSON.toJson(nbtElement)) : JsonToNBT.func_180713_a((String)JSONUtils.func_151206_a((JsonElement)nbtElement, (String)NBT_TAG));
                }
                if ((copyElement = json.get(COPY_TAG)) != null && copyElement.isJsonObject()) {
                    JsonObject copyObject = copyElement.getAsJsonObject();
                    Ingredient ingredient = Ingredient.func_199802_a((JsonElement)copyObject.get(INGREDIENT_TAG));
                    String tag = null;
                    if (copyObject.has(TAG_TAG) && StringUtils.isNotBlank((CharSequence)copyObject.get(TAG_TAG).getAsString())) {
                        tag = copyObject.get(TAG_TAG).getAsString();
                    }
                    return new Output(type, outputData, ingredient, tag);
                }
                return new Output(type, outputData);
            }
            throw new JsonParseException("Entity Type Tag Not Found");
        }
        catch (CommandSyntaxException e) {
            throw new JsonSyntaxException("Invalid NBT Entry: " + e.toString());
        }
    }

    public static class Output {
        private final EntityType<?> type;
        private final CompoundNBT data;
        private final Ingredient copyInput;
        private final String copyTag;

        public Output(EntityType<?> type, CompoundNBT data, Ingredient copyInput, @Nullable String copyTag) {
            this.type = type;
            this.data = data;
            this.copyInput = copyInput;
            this.copyTag = copyTag;
        }

        public Output(EntityType<?> type, CompoundNBT data) {
            this(type, data, Ingredient.field_193370_a, null);
        }

        public EntityType<?> getType() {
            return this.type;
        }

        public CompoundNBT getData() {
            return this.data;
        }

        public Ingredient getCopyInput() {
            return this.copyInput;
        }

        @Nullable
        public String getCopyTag() {
            return this.copyTag;
        }
    }
}

