/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.util;

import com.github.tartaricacid.touhoulittlemaid.api.bauble.IMaidBauble;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.inventory.handler.BaubleItemHandler;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;

public final class ItemsUtil {
    private ItemsUtil() {
    }

    public static void dropEntityItems(Entity entity, IItemHandler itemHandler, int startIndex, int endIndex) {
        for (int i = startIndex; i < endIndex; ++i) {
            ItemStack stackInSlot = itemHandler.getStackInSlot(i);
            ItemStack extractItem = itemHandler.extractItem(i, stackInSlot.func_190916_E(), false);
            InventoryHelper.func_180173_a((World)entity.field_70170_p, (double)entity.func_226277_ct_(), (double)entity.func_226278_cu_(), (double)entity.func_226281_cx_(), (ItemStack)extractItem);
        }
    }

    public static void dropEntityItems(Entity entity, IItemHandler itemHandler) {
        ItemsUtil.dropEntityItems(entity, itemHandler, 0, itemHandler.getSlots());
    }

    public static void dropEntityItems(Entity entity, IItemHandler itemHandler, int startIndex) {
        ItemsUtil.dropEntityItems(entity, itemHandler, startIndex, itemHandler.getSlots());
    }

    public static int findStackSlot(IItemHandler handler, Predicate<ItemStack> filter) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (!filter.test(stack)) continue;
            return i;
        }
        return -1;
    }

    public static List<Integer> getFilterStackSlots(IItemHandler handler, Predicate<ItemStack> filter) {
        IntArrayList slots = new IntArrayList();
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (!filter.test(stack)) continue;
            slots.add(i);
        }
        return slots;
    }

    public static boolean isStackIn(IItemHandler handler, Predicate<ItemStack> filter) {
        return ItemsUtil.findStackSlot(handler, filter) >= 0;
    }

    public static ItemStack getStack(IItemHandler handler, Predicate<ItemStack> filter) {
        int slotIndex = ItemsUtil.findStackSlot(handler, filter);
        if (slotIndex >= 0) {
            return handler.getStackInSlot(slotIndex);
        }
        return ItemStack.field_190927_a;
    }

    public static int getBaubleSlotInMaid(EntityMaid maid, IMaidBauble bauble) {
        BaubleItemHandler handler = maid.getMaidBauble();
        for (int i = 0; i < handler.getSlots(); ++i) {
            IMaidBauble baubleIn = handler.getBaubleInSlot(i);
            if (baubleIn != bauble) continue;
            return i;
        }
        return -1;
    }
}

