/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.util;

import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class MaidFluidUtil {
    public static FluidActionResult tankToBucket(ItemStack bucket, IFluidHandler tank, IItemHandler maidBackpack) {
        ItemStack remainder;
        if (bucket.func_190926_b()) {
            return FluidActionResult.FAILURE;
        }
        FluidActionResult filledSimulated = FluidUtil.tryFillContainer((ItemStack)bucket, (IFluidHandler)tank, (int)Integer.MAX_VALUE, null, (boolean)false);
        if (filledSimulated.isSuccess() && (remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)maidBackpack, (ItemStack)filledSimulated.getResult(), (boolean)true)).func_190926_b()) {
            FluidActionResult filledReal = FluidUtil.tryFillContainer((ItemStack)bucket, (IFluidHandler)tank, (int)Integer.MAX_VALUE, null, (boolean)true);
            ItemHandlerHelper.insertItemStacked((IItemHandler)maidBackpack, (ItemStack)filledReal.getResult(), (boolean)false);
            bucket.func_190918_g(1);
            return new FluidActionResult(bucket);
        }
        return FluidActionResult.FAILURE;
    }

    public static FluidActionResult bucketToTank(ItemStack bucket, IFluidHandler tank, IItemHandler maidBackpack) {
        ItemStack remainder;
        if (bucket.func_190926_b()) {
            return FluidActionResult.FAILURE;
        }
        FluidActionResult emptiedSimulated = MaidFluidUtil.tryEmptyContainer(bucket, tank, false);
        if (emptiedSimulated.isSuccess() && (remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)maidBackpack, (ItemStack)emptiedSimulated.getResult(), (boolean)true)).func_190926_b()) {
            FluidActionResult emptiedReal = MaidFluidUtil.tryEmptyContainer(bucket, tank, true);
            ItemHandlerHelper.insertItemStacked((IItemHandler)maidBackpack, (ItemStack)emptiedReal.getResult(), (boolean)false);
            bucket.func_190918_g(1);
            return new FluidActionResult(bucket);
        }
        return FluidActionResult.FAILURE;
    }

    private static FluidActionResult tryEmptyContainer(@Nonnull ItemStack container, IFluidHandler fluidDestination, boolean doDrain) {
        ItemStack containerCopy = ItemHandlerHelper.copyStackWithSize((ItemStack)container, (int)1);
        return FluidUtil.getFluidHandler((ItemStack)containerCopy).map(containerFluidHandler -> {
            FluidStack transfer = FluidUtil.tryFluidTransfer((IFluidHandler)fluidDestination, (IFluidHandler)containerFluidHandler, (int)Integer.MAX_VALUE, (boolean)doDrain);
            if (transfer.isEmpty()) {
                return FluidActionResult.FAILURE;
            }
            if (!doDrain) {
                containerFluidHandler.drain(transfer, IFluidHandler.FluidAction.EXECUTE);
            }
            ItemStack resultContainer = containerFluidHandler.getContainer();
            return new FluidActionResult(resultContainer);
        }).orElse(FluidActionResult.FAILURE);
    }
}

