/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public final class ParseI18n {
    private static final String I18N_START_CHAR = "{";
    private static final String I18N_END_CHAR = "}";

    private ParseI18n() {
    }

    public static String getI18nKey(String strIn) {
        if (strIn.startsWith(I18N_START_CHAR) && strIn.endsWith(I18N_END_CHAR)) {
            return strIn.substring(1, strIn.length() - 1);
        }
        return strIn;
    }

    public static ITextComponent parse(String strIn) {
        if (strIn.startsWith(I18N_START_CHAR) && strIn.endsWith(I18N_END_CHAR)) {
            return new TranslationTextComponent(strIn.substring(1, strIn.length() - 1));
        }
        return new StringTextComponent(strIn);
    }

    public static List<ITextComponent> parse(List<String> strIn) {
        ArrayList strOut = Lists.newArrayList();
        for (String str : strIn) {
            strOut.add(ParseI18n.parse(str));
        }
        return strOut;
    }

    public static List<ITextComponent> keysToTrans(List<String> keys, TextFormatting ... formatting) {
        ArrayList out = Lists.newArrayList();
        for (String k : keys) {
            out.add(new TranslationTextComponent(k).func_240701_a_(formatting));
        }
        return out;
    }
}

