/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.util;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import java.util.Random;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public final class SoundUtil {
    private static final long MORNING_START = 0L;
    private static final long MORNING_END = 3000L;
    private static final long EVENING_START = 12000L;
    private static final long EVENING_END = 15000L;
    private static final float LOW_TEMPERATURE = 0.15f;
    private static final float HIGH_TEMPERATURE = 0.95f;

    public static SoundEvent environmentSound(EntityMaid maid, SoundEvent fallback, float probability) {
        World world = maid.field_70170_p;
        Random rand = maid.func_70681_au();
        BlockPos pos = maid.func_233580_cy_();
        long dayTime = world.func_72820_D();
        Biome biome = world.func_226691_t_(pos);
        if (rand.nextFloat() < probability && 0L < dayTime && dayTime < 3000L) {
            return (SoundEvent)InitSounds.MAID_MORNING.get();
        }
        if (rand.nextFloat() < probability && 12000L < dayTime && dayTime < 15000L) {
            return (SoundEvent)InitSounds.MAID_NIGHT.get();
        }
        if (rand.nextFloat() < probability && world.func_72896_J() && SoundUtil.isRainBiome(biome, pos)) {
            return (SoundEvent)InitSounds.MAID_RAIN.get();
        }
        if (rand.nextFloat() < probability && world.func_72896_J() && SoundUtil.isSnowyBiome(biome, pos)) {
            return (SoundEvent)InitSounds.MAID_SNOW.get();
        }
        if (rand.nextFloat() < probability && biome.func_225486_c(pos) < 0.15f) {
            return (SoundEvent)InitSounds.MAID_COLD.get();
        }
        if (rand.nextFloat() < probability && biome.func_225486_c(pos) > 0.95f) {
            return (SoundEvent)InitSounds.MAID_HOT.get();
        }
        return fallback;
    }

    public static SoundEvent attackSound(EntityMaid maid, SoundEvent fallback, float probability) {
        Random rand = maid.func_70681_au();
        if (rand.nextFloat() < probability) {
            return (SoundEvent)InitSounds.MAID_FIND_TARGET.get();
        }
        return fallback;
    }

    public static boolean isRainBiome(Biome biome, BlockPos pos) {
        float temp = biome.func_225486_c(pos);
        return biome.func_201851_b() == Biome.RainType.RAIN && 0.15f <= temp && temp <= 0.95f;
    }

    public static boolean isSnowyBiome(Biome biome, BlockPos pos) {
        return biome.func_201851_b() == Biome.RainType.SNOW && biome.func_225486_c(pos) < 0.15f;
    }
}

