/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.world.data;

import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityTombstone;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.world.data.MaidInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.WorldSavedData;

public class MaidWorldData
extends WorldSavedData {
    private static final String IDENTIFIER = "touhou_little_maid_world_data";
    private static final String MAID_INFOS_TAG = "MaidInfos";
    private static final String MAID_TOMBSTONES_TAG = "MaidTombstones";
    private final Map<UUID, List<MaidInfo>> infos = Maps.newHashMap();
    private final Map<UUID, List<MaidInfo>> tombstones = Maps.newHashMap();

    public MaidWorldData() {
        super(IDENTIFIER);
    }

    @Nullable
    public static MaidWorldData get(World level) {
        if (level instanceof ServerWorld) {
            ServerWorld overWorld = level.func_73046_m().func_71218_a(World.field_234918_g_);
            if (overWorld == null) {
                return null;
            }
            DimensionSavedDataManager storage = overWorld.func_217481_x();
            MaidWorldData data = (MaidWorldData)storage.func_215752_a(MaidWorldData::new, IDENTIFIER);
            data.func_76185_a();
            return data;
        }
        return null;
    }

    public void func_76184_a(CompoundNBT tag) {
        IFormattableTextComponent name;
        long timestamp;
        UUID ownerId;
        BlockPos chunkPos;
        String dimension;
        CompoundNBT infoTag;
        int i;
        ListNBT listTag;
        if (tag.func_150297_b(MAID_INFOS_TAG, 10)) {
            CompoundNBT infosTag = tag.func_74775_l(MAID_INFOS_TAG);
            for (String key : infosTag.func_150296_c()) {
                listTag = infosTag.func_150295_c(key, 10);
                for (i = 0; i < listTag.size(); ++i) {
                    infoTag = listTag.func_150305_b(i);
                    dimension = infoTag.func_74779_i("Dimension");
                    chunkPos = NBTUtil.func_186861_c((CompoundNBT)infoTag.func_74775_l("ChunkPos"));
                    ownerId = infoTag.func_186857_a("OwnerId");
                    UUID maidId = infoTag.func_186857_a("MaidId");
                    timestamp = infoTag.func_74763_f("Timestamp");
                    name = ITextComponent.Serializer.func_240643_a_((String)infoTag.func_74779_i("Name"));
                    List maidInfos = this.infos.computeIfAbsent(ownerId, uuid -> Lists.newArrayList());
                    maidInfos.add(new MaidInfo(dimension, chunkPos, ownerId, maidId, timestamp, (ITextComponent)name));
                }
            }
        }
        if (tag.func_150297_b(MAID_TOMBSTONES_TAG, 10)) {
            CompoundNBT tombstonesTag = tag.func_74775_l(MAID_TOMBSTONES_TAG);
            for (String key : tombstonesTag.func_150296_c()) {
                listTag = tombstonesTag.func_150295_c(key, 10);
                for (i = 0; i < listTag.size(); ++i) {
                    infoTag = listTag.func_150305_b(i);
                    dimension = infoTag.func_74779_i("Dimension");
                    chunkPos = NBTUtil.func_186861_c((CompoundNBT)infoTag.func_74775_l("ChunkPos"));
                    ownerId = infoTag.func_186857_a("OwnerId");
                    UUID tombstoneId = infoTag.func_186857_a("TombstoneId");
                    timestamp = infoTag.func_74763_f("Timestamp");
                    name = ITextComponent.Serializer.func_240643_a_((String)infoTag.func_74779_i("Name"));
                    List tombstoneInfos = this.tombstones.computeIfAbsent(ownerId, uuid -> Lists.newArrayList());
                    tombstoneInfos.add(new MaidInfo(dimension, chunkPos, ownerId, tombstoneId, timestamp, (ITextComponent)name));
                }
            }
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT tag) {
        CompoundNBT infosTag = new CompoundNBT();
        this.infos.forEach((id, data) -> {
            ListNBT listTag = new ListNBT();
            data.forEach(info -> {
                CompoundNBT infoTag = new CompoundNBT();
                infoTag.func_74778_a("Dimension", info.getDimension());
                infoTag.func_218657_a("ChunkPos", (INBT)NBTUtil.func_186859_a((BlockPos)info.getChunkPos()));
                infoTag.func_186854_a("OwnerId", info.getOwnerId());
                infoTag.func_186854_a("MaidId", info.getEntityId());
                infoTag.func_74772_a("Timestamp", info.getTimestamp());
                infoTag.func_74778_a("Name", ITextComponent.Serializer.func_150696_a((ITextComponent)info.getName()));
                listTag.add((Object)infoTag);
            });
            infosTag.func_218657_a(id.toString(), (INBT)listTag);
        });
        CompoundNBT tombstonesTag = new CompoundNBT();
        this.tombstones.forEach((id, data) -> {
            ListNBT listTag = new ListNBT();
            data.forEach(info -> {
                CompoundNBT infoTag = new CompoundNBT();
                infoTag.func_74778_a("Dimension", info.getDimension());
                infoTag.func_218657_a("ChunkPos", (INBT)NBTUtil.func_186859_a((BlockPos)info.getChunkPos()));
                infoTag.func_186854_a("OwnerId", info.getOwnerId());
                infoTag.func_186854_a("TombstoneId", info.getEntityId());
                infoTag.func_74772_a("Timestamp", info.getTimestamp());
                infoTag.func_74778_a("Name", ITextComponent.Serializer.func_150696_a((ITextComponent)info.getName()));
                listTag.add((Object)infoTag);
            });
            tombstonesTag.func_218657_a(id.toString(), (INBT)listTag);
        });
        tag.func_218657_a(MAID_INFOS_TAG, (INBT)infosTag);
        tag.func_218657_a(MAID_TOMBSTONES_TAG, (INBT)tombstonesTag);
        return tag;
    }

    public void addInfo(MaidInfo info) {
        UUID ownerId = info.getOwnerId();
        List maidInfos = this.infos.computeIfAbsent(ownerId, uuid -> Lists.newArrayList());
        maidInfos.add(info);
        this.func_76185_a();
    }

    public void addInfo(EntityMaid maid) {
        String dimension = maid.field_70170_p.func_234923_W_().func_240901_a_().toString();
        BlockPos chunkPos = maid.func_233580_cy_();
        UUID ownerId = maid.func_184753_b();
        UUID maidId = maid.func_110124_au();
        long timestamp = System.currentTimeMillis();
        ITextComponent name = maid.func_145748_c_();
        this.addInfo(new MaidInfo(dimension, chunkPos, ownerId, maidId, timestamp, name));
    }

    public void removeInfo(EntityMaid maid) {
        UUID ownerId = maid.func_184753_b();
        if (this.infos.containsKey(ownerId)) {
            UUID maidId = maid.func_110124_au();
            this.infos.get(ownerId).removeIf(info -> info.getEntityId().equals(maidId));
            this.func_76185_a();
        }
    }

    @Nullable
    public List<MaidInfo> getInfos(UUID owner) {
        return this.infos.get(owner);
    }

    @Nullable
    public List<MaidInfo> getPlayerMaidInfos(PlayerEntity player) {
        return this.infos.get(player.func_110124_au());
    }

    public void addTombstones(MaidInfo info) {
        UUID ownerId = info.getOwnerId();
        List tombstoneInfos = this.tombstones.computeIfAbsent(ownerId, uuid -> Lists.newArrayList());
        tombstoneInfos.add(info);
        this.func_76185_a();
    }

    public void addTombstones(EntityMaid maid, EntityTombstone tombstone) {
        String dimension = maid.field_70170_p.func_234923_W_().func_240901_a_().toString();
        BlockPos chunkPos = tombstone.func_233580_cy_();
        UUID ownerId = maid.func_184753_b();
        UUID tombstoneId = tombstone.func_110124_au();
        long timestamp = System.currentTimeMillis();
        ITextComponent name = maid.func_145748_c_();
        this.addTombstones(new MaidInfo(dimension, chunkPos, ownerId, tombstoneId, timestamp, name));
    }

    public void removeTombstones(EntityTombstone tombstone) {
        UUID ownerId = tombstone.getOwnerId();
        if (this.tombstones.containsKey(ownerId)) {
            UUID tombstoneId = tombstone.func_110124_au();
            this.tombstones.get(ownerId).removeIf(info -> info.getEntityId().equals(tombstoneId));
            this.func_76185_a();
        }
    }

    @Nullable
    public List<MaidInfo> getTombstones(UUID owner) {
        return this.tombstones.get(owner);
    }

    @Nullable
    public List<MaidInfo> getPlayerMaidTombstones(PlayerEntity player) {
        return this.tombstones.get(player.func_110124_au());
    }
}

